/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.ConllXPOSSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

public class ConllXPOSSampleStreamFactory
extends AbstractSampleStreamFactory<POSSample> {
    public static final String CONLLX_FORMAT = "conllx";

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, (String)CONLLX_FORMAT, (ObjectStreamFactory)new ConllXPOSSampleStreamFactory(Parameters.class));
    }

    protected <P> ConllXPOSSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        InputStreamFactory inFactory = CmdLineUtil.createInputStreamFactory((File)params.getData());
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
            return new ConllXPOSSampleStream(inFactory, Charset.forName("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new TerminateToolException(-1, "UTF-8 encoding is not supported: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError((IOException)e);
            return null;
        }
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

