/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.EvalitaNameSampleStream;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

public class EvalitaNameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, (String)"evalita", (ObjectStreamFactory)new EvalitaNameSampleStreamFactory(Parameters.class));
    }

    protected <P> EvalitaNameSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        if (!"it".equals(params.getLang())) {
            throw new TerminateToolException(1, "Unsupported language: " + params.getLang());
        }
        EvalitaNameSampleStream.LANGUAGE lang = EvalitaNameSampleStream.LANGUAGE.IT;
        this.language = params.getLang();
        int typesToGenerate = 0;
        if (params.getTypes().contains("per")) {
            typesToGenerate |= 1;
        }
        if (params.getTypes().contains("org")) {
            typesToGenerate |= 2;
        }
        if (params.getTypes().contains("loc")) {
            typesToGenerate |= 4;
        }
        if (params.getTypes().contains("gpe")) {
            typesToGenerate |= 8;
        }
        try {
            return new EvalitaNameSampleStream(lang, CmdLineUtil.createInputStreamFactory((File)params.getData()), typesToGenerate);
        }
        catch (IOException e) {
            throw CmdLineUtil.createObjectStreamError((IOException)e);
        }
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="it")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="per,loc,org,gpe")
        public String getTypes();
    }
}

