/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class TokenSampleStreamFactory
extends LanguageSampleStreamFactory<TokenSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(TokenSample.class, (String)"opennlp", (ObjectStreamFactory)new TokenSampleStreamFactory(Parameters.class));
    }

    protected <P> TokenSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public ObjectStream<TokenSample> create(String[] args) {
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        CmdLineUtil.checkInputFile((String)"Data", (File)params.getData());
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory((File)params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError((IOException)ex);
        }
        return new TokenSampleStream(lineStream);
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

