/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.formats.ad.ADSentenceSampleStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class ADSentenceSampleStreamFactory
extends LanguageSampleStreamFactory<SentenceSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, (String)"ad", (ObjectStreamFactory)new ADSentenceSampleStreamFactory(Parameters.class));
    }

    protected <P> ADSentenceSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        this.language = params.getLang();
        boolean includeTitle = params.getIncludeTitles();
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory((File)params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError((IOException)ex);
        }
        ADSentenceSampleStream sentenceStream = new ADSentenceSampleStream(lineStream, includeTitle);
        return sentenceStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="includeTitles", description="if true will include sentences marked as headlines.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getIncludeTitles();
    }
}

