/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.cmdline.tokenizer.TokenizerModelLoader;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.muc.MucNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.StringUtil;

public class Muc6NameSampleStreamFactory
extends AbstractSampleStreamFactory<NameSample> {
    protected Muc6NameSampleStreamFactory() {
        super(Parameters.class);
    }

    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = (Parameters)ArgumentParser.parse((String[])args, Parameters.class);
        TokenizerModel tokenizerModel = (TokenizerModel)new TokenizerModelLoader().load(params.getTokenizerModel());
        TokenizerME tokenizer = new TokenizerME(tokenizerModel);
        FileToStringSampleStream mucDocStream = new FileToStringSampleStream(new DirectorySampleStream(params.getData(), new FileFilter(){

            @Override
            public boolean accept(File file) {
                return StringUtil.toLowerCase(file.getName()).endsWith(".sgm");
            }
        }, false), Charset.forName("UTF-8"));
        return new MucNameSampleStream(tokenizer, mucDocStream);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, (String)"muc6", (ObjectStreamFactory)new Muc6NameSampleStreamFactory());
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="modelFile")
        public File getTokenizerModel();
    }
}

