/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ontonotes;

import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.ontonotes.DocumentToLineStream;
import opennlp.tools.formats.ontonotes.OntoNotesFormatParameters;
import opennlp.tools.formats.ontonotes.OntoNotesParseSampleStream;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.ObjectStream;

public class OntoNotesParseSampleStreamFactory
extends AbstractSampleStreamFactory<Parse> {
    protected OntoNotesParseSampleStreamFactory() {
        super(OntoNotesFormatParameters.class);
    }

    public ObjectStream<Parse> create(String[] args) {
        OntoNotesFormatParameters params = (OntoNotesFormatParameters)ArgumentParser.parse((String[])args, OntoNotesFormatParameters.class);
        DirectorySampleStream documentStream = new DirectorySampleStream(new File(params.getOntoNotesDir()), new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    return file.getName().endsWith(".parse");
                }
                return file.isDirectory();
            }
        }, true);
        return new OntoNotesParseSampleStream(new DocumentToLineStream(new FileToStringSampleStream(documentStream, Charset.forName("UTF-8"))));
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(Parse.class, (String)"ontonotes", (ObjectStreamFactory)new OntoNotesParseSampleStreamFactory());
    }
}

