/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.servlet;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.error.Error;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.ServiceManager;
import org.apache.abdera.protocol.server.servlet.ServletRequestContext;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbderaServlet
extends HttpServlet {
    private static final long serialVersionUID = 2393643907128535158L;
    private static final Log log = LogFactory.getLog(AbderaServlet.class);
    protected ServiceManager manager;
    protected Provider provider;

    @Override
    public void init() throws ServletException {
        log.debug("Initialing Abdera Servlet");
        this.manager = this.createServiceManager();
        this.provider = this.createProvider();
        log.debug("Using provider - " + this.provider);
    }

    public Abdera getAbdera() {
        return ServiceManager.getAbdera();
    }

    public ServiceManager getServiceManager() {
        return this.manager;
    }

    protected ServiceManager createServiceManager() {
        return ServiceManager.getInstance();
    }

    protected Provider createProvider() {
        return this.manager.newProvider(this.getProperties(this.getServletConfig()));
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletRequestContext reqcontext = new ServletRequestContext(this.provider, request, this.getServletContext());
        FilterChain chain = new FilterChain(this.provider, reqcontext);
        try {
            this.output(request, response, chain.next(reqcontext));
        }
        catch (Throwable t) {
            this.error("Error servicing request", t, response);
            return;
        }
        log.debug("Request complete");
    }

    private void output(HttpServletRequest request, HttpServletResponse response, ResponseContext context) throws IOException {
        if (context != null) {
            String[] names;
            response.setStatus(context.getStatus());
            long cl = context.getContentLength();
            String cc = context.getCacheControl();
            if (cl > -1L) {
                response.setHeader("Content-Length", Long.toString(cl));
            }
            if (cc != null && cc.length() > 0) {
                response.setHeader("Cache-Control", cc);
            }
            try {
                MimeType ct = context.getContentType();
                if (ct != null) {
                    response.setContentType(ct.toString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            for (String name : names = context.getHeaderNames()) {
                Object[] headers;
                for (Object value : headers = context.getHeaders(name)) {
                    if (value instanceof Date) {
                        response.setDateHeader(name, ((Date)value).getTime());
                        continue;
                    }
                    response.setHeader(name, value.toString());
                }
            }
            if (!request.getMethod().equals("HEAD") && context.hasEntity()) {
                if (context.isBinary()) {
                    context.writeTo(response.getOutputStream());
                } else {
                    context.writeTo(response.getWriter());
                }
            }
        } else {
            this.error("Internal Server Error", null, response);
        }
    }

    private void error(String message, Throwable t, HttpServletResponse response) throws IOException {
        if (t != null) {
            log.error(message, t);
        } else {
            log.error(message);
        }
        if (response.isCommitted()) {
            log.error("Could not write an error message as the headers & HTTP status were already committed!");
        } else {
            response.setStatus(500);
            StreamWriter sw = this.getAbdera().newStreamWriter().setOutputStream(response.getOutputStream(), "UTF-8");
            Error.create(sw, 500, message, t);
            sw.close();
        }
    }

    protected Map<String, String> getProperties(ServletConfig config) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration<String> e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String val = config.getInitParameter(key);
            properties.put(key, val);
        }
        return properties;
    }
}

