/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.AbstractRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestContext
extends AbstractRequestContext
implements RequestContext {
    private final HttpServletRequest request;
    private final ServletContext servletContext;
    private HttpSession session;

    public ServletRequestContext(Provider provider, HttpServletRequest request, ServletContext servletContext) {
        super(provider, request.getMethod(), ServletRequestContext.initRequestUri(request), ServletRequestContext.initBaseUri(provider, request));
        this.request = request;
        this.servletContext = servletContext;
        this.session = request.getSession(false);
        this.principal = request.getUserPrincipal();
        this.subject = provider.resolveSubject(this);
        this.target = this.initTarget();
    }

    @Override
    public Object getProperty(RequestContext.Property property) {
        switch (property) {
            case SESSIONID: {
                return this.session != null ? this.session.getId() : null;
            }
            case SESSIONCREATED: {
                return this.session != null ? new Date(this.session.getCreationTime()) : null;
            }
            case SESSIONACCESSED: {
                return this.session != null ? new Date(this.session.getLastAccessedTime()) : null;
            }
            case SESSIONTIMEOUT: {
                return this.session != null ? this.session.getMaxInactiveInterval() : -1;
            }
            case CHARACTERENCODING: {
                return this.request.getCharacterEncoding();
            }
            case LOCALES: {
                return this.request.getLocales();
            }
            case PROTOCOL: {
                return this.request.getProtocol();
            }
            case REMOTEADDRESS: {
                return this.request.getRemoteAddr();
            }
            case REMOTEHOST: {
                return this.request.getRemoteHost();
            }
            case REMOTEUSER: {
                return this.request.getRemoteUser();
            }
            case SCHEME: {
                return this.request.getScheme();
            }
            case PRINCIPAL: {
                return this.request.getUserPrincipal();
            }
            case AUTHTYPE: {
                return this.request.getAuthType();
            }
            case CONTENTLENGTH: {
                return this.request.getContentLength();
            }
            case CONTENTTYPE: {
                return this.request.getContentType();
            }
            case CONTEXTPATH: {
                return this.request.getContextPath();
            }
            case LOCALADDR: {
                return this.request.getLocalAddr();
            }
            case LOCALNAME: {
                return this.request.getLocalName();
            }
            case SERVERNAME: {
                return this.request.getServerName();
            }
            case SERVERPORT: {
                return this.request.getServerPort();
            }
            case SECURE: {
                return this.request.isSecure();
            }
        }
        throw new UnsupportedOperationException(Localizer.get("PROPERTY.NOT.SUPPORTED"));
    }

    @Override
    public Reader getReader() throws IOException {
        return this.request.getReader();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public synchronized HttpSession getSession() {
        return this.getSession(false);
    }

    public synchronized HttpSession getSession(boolean create) {
        if (this.session == null) {
            this.session = this.request.getSession(create);
        }
        return this.session;
    }

    @Override
    public RequestContext setAttribute(RequestContext.Scope scope, String name, Object value) {
        switch (scope) {
            case REQUEST: {
                this.request.setAttribute(name, value);
                break;
            }
            case SESSION: {
                this.getSession(true).setAttribute(name, value);
                break;
            }
            case CONTAINER: {
                ServletContext scontext = this.getServletContext();
                if (scontext == null) break;
                scontext.setAttribute(name, value);
            }
        }
        return this;
    }

    @Override
    public Object getAttribute(RequestContext.Scope scope, String name) {
        switch (scope) {
            case REQUEST: {
                return this.request.getAttribute(name);
            }
            case SESSION: {
                return this.session != null ? this.session.getAttribute(name) : null;
            }
            case CONTAINER: {
                ServletContext scontext = this.getServletContext();
                return scontext != null ? scontext.getAttribute(name) : null;
            }
        }
        return null;
    }

    @Override
    public String[] getAttributeNames(RequestContext.Scope scope) {
        switch (scope) {
            case REQUEST: {
                return ServletRequestContext.enum2array(this.request.getAttributeNames());
            }
            case SESSION: {
                return this.session != null ? ServletRequestContext.enum2array(this.session.getAttributeNames()) : null;
            }
            case CONTAINER: {
                ServletContext scontext = this.getServletContext();
                return scontext != null ? ServletRequestContext.enum2array(scontext.getAttributeNames()) : null;
            }
        }
        return null;
    }

    @Override
    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public String[] getParameterNames() {
        return ServletRequestContext.enum2array(this.request.getParameterNames());
    }

    @Override
    public List<String> getParameters(String name) {
        String[] values = this.request.getParameterValues(name);
        return values != null ? Arrays.asList(values) : null;
    }

    @Override
    public Date getDateHeader(String name) {
        long value = this.request.getDateHeader(name);
        return value != -1L ? new Date(value) : null;
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public String[] getHeaderNames() {
        return ServletRequestContext.enum2array(this.request.getHeaderNames());
    }

    @Override
    public Object[] getHeaders(String name) {
        Enumeration<String> e = this.request.getHeaders(name);
        ArrayList<String> list = Collections.list(e);
        return list.toArray(new String[list.size()]);
    }

    private static String[] enum2array(Enumeration<String> e) {
        ArrayList<String> list = Collections.list(e);
        return list.toArray(new String[list.size()]);
    }

    private static String getHost(Provider provider, HttpServletRequest request) {
        Abdera abdera = provider.getAbdera();
        String host = abdera.getConfiguration().getConfigurationOption("org.apache.abdera.protocol.server.Host");
        return host != null ? host : request.getServerName();
    }

    private static int getPort(Provider provider, HttpServletRequest request) {
        Abdera abdera = provider.getAbdera();
        String port = abdera.getConfiguration().getConfigurationOption("org.apache.abdera.protocol.server.Port");
        return port != null ? Integer.parseInt(port) : request.getServerPort();
    }

    private static IRI initBaseUri(Provider provider, HttpServletRequest request) {
        StringBuilder buffer = new StringBuilder(request.isSecure() ? "https" : "http");
        buffer.append("://");
        buffer.append(ServletRequestContext.getHost(provider, request));
        int port = ServletRequestContext.getPort(provider, request);
        if (port != 80) {
            buffer.append(":");
            buffer.append(port);
        }
        buffer.append(request.getContextPath());
        buffer.append("/");
        return new IRI(buffer.toString());
    }

    private static IRI initRequestUri(HttpServletRequest request) {
        StringBuilder buf = new StringBuilder(request.getRequestURI());
        String qs = request.getQueryString();
        if (qs != null && qs.length() != 0) {
            buf.append("?").append(request.getQueryString());
        }
        IRI uri = new IRI(buf.toString());
        return uri;
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    @Override
    public String getContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public Locale getPreferredLocale() {
        return this.request.getLocale();
    }

    @Override
    public Locale[] getPreferredLocales() {
        ArrayList<Locale> locales = Collections.list(this.request.getLocales());
        return locales.toArray(new Locale[locales.size()]);
    }

    @Override
    public String getTargetBasePath() {
        return this.request.getContextPath() + this.request.getServletPath();
    }
}

