/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.management.JMRuntimeException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.apache.aries.jmx.util.TypeUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundleData {
    private String[] exportedPackages;
    private boolean fragment;
    private long[] fragments;
    private List<Header> headers = new ArrayList<Header>();
    private long[] hosts;
    private long identifier;
    private String[] importedPackages;
    private long lastModified;
    private String location;
    private boolean persistentlyStarted;
    private long[] registeredServices;
    private boolean removalPending;
    private boolean required;
    private long[] requiredBundles;
    private long[] requiringBundles;
    private long[] servicesInUse;
    private int bundleStartLevel;
    private String state;
    private String symbolicName;
    private String version;

    private BundleData() {
    }

    public BundleData(BundleContext localBundleContext, Bundle bundle, PackageAdmin packageAdmin, StartLevel startLevel) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null || startLevel == null) {
            throw new IllegalArgumentException("Arguments PackageAdmin / startLevel cannot be null");
        }
        this.exportedPackages = FrameworkUtils.getBundleExportedPackages((Bundle)bundle, (PackageAdmin)packageAdmin);
        this.fragment = 1 == packageAdmin.getBundleType(bundle);
        this.fragments = FrameworkUtils.getFragmentIds((Bundle)bundle, (PackageAdmin)packageAdmin);
        Dictionary bundleHeaders = bundle.getHeaders();
        Enumeration keys = bundleHeaders.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.headers.add(new Header(key, (String)bundleHeaders.get(key)));
        }
        this.hosts = FrameworkUtils.getHostIds((Bundle)bundle, (PackageAdmin)packageAdmin);
        this.identifier = bundle.getBundleId();
        this.importedPackages = FrameworkUtils.getBundleImportedPackages((BundleContext)localBundleContext, (Bundle)bundle, (PackageAdmin)packageAdmin);
        this.lastModified = bundle.getLastModified();
        this.location = bundle.getLocation();
        this.persistentlyStarted = startLevel.isBundlePersistentlyStarted(bundle);
        this.registeredServices = FrameworkUtils.getRegisteredServiceIds((Bundle)bundle);
        this.removalPending = FrameworkUtils.isBundlePendingRemoval((Bundle)bundle, (PackageAdmin)packageAdmin);
        this.required = FrameworkUtils.isBundleRequiredByOthers((Bundle)bundle, (PackageAdmin)packageAdmin);
        this.requiredBundles = FrameworkUtils.getBundleDependencies((BundleContext)localBundleContext, (Bundle)bundle, (PackageAdmin)packageAdmin);
        this.requiringBundles = FrameworkUtils.getDependentBundles((Bundle)bundle, (PackageAdmin)packageAdmin);
        this.servicesInUse = FrameworkUtils.getServicesInUseByBundle((Bundle)bundle);
        this.bundleStartLevel = startLevel.getBundleStartLevel(bundle);
        this.state = FrameworkUtils.getBundleState((Bundle)bundle);
        this.symbolicName = bundle.getSymbolicName();
        this.version = bundle.getVersion().toString();
    }

    public CompositeData toCompositeData() {
        return this.toCompositeData(BundleStateMBean.BUNDLE_TYPE.keySet());
    }

    public CompositeData toCompositeData(Collection<String> itemNames) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.identifier);
        if (itemNames.contains("ExportedPackages")) {
            items.put("ExportedPackages", this.exportedPackages);
        }
        if (itemNames.contains("Fragment")) {
            items.put("Fragment", this.fragment);
        }
        if (itemNames.contains("Fragments")) {
            items.put("Fragments", TypeUtils.toLong((long[])this.fragments));
        }
        if (itemNames.contains("Hosts")) {
            items.put("Hosts", TypeUtils.toLong((long[])this.hosts));
        }
        if (itemNames.contains("ImportedPackages")) {
            items.put("ImportedPackages", this.importedPackages);
        }
        if (itemNames.contains("LastModified")) {
            items.put("LastModified", this.lastModified);
        }
        if (itemNames.contains("Location")) {
            items.put("Location", this.location);
        }
        if (itemNames.contains("PersistentlyStarted")) {
            items.put("PersistentlyStarted", this.persistentlyStarted);
        }
        if (itemNames.contains("RegisteredServices")) {
            items.put("RegisteredServices", TypeUtils.toLong((long[])this.registeredServices));
        }
        if (itemNames.contains("RemovalPending")) {
            items.put("RemovalPending", this.removalPending);
        }
        if (itemNames.contains("Required")) {
            items.put("Required", this.required);
        }
        if (itemNames.contains("RequiredBundles")) {
            items.put("RequiredBundles", TypeUtils.toLong((long[])this.requiredBundles));
        }
        if (itemNames.contains("RequiringBundles")) {
            items.put("RequiringBundles", TypeUtils.toLong((long[])this.requiringBundles));
        }
        if (itemNames.contains("ServicesInUse")) {
            items.put("ServicesInUse", TypeUtils.toLong((long[])this.servicesInUse));
        }
        if (itemNames.contains("StartLevel")) {
            items.put("StartLevel", this.bundleStartLevel);
        }
        if (itemNames.contains("State")) {
            items.put("State", this.state);
        }
        if (itemNames.contains("SymbolicName")) {
            items.put("SymbolicName", this.symbolicName);
        }
        if (itemNames.contains("Version")) {
            items.put("Version", this.version);
        }
        if (itemNames.contains("Headers")) {
            TabularDataSupport headerTable = new TabularDataSupport(BundleStateMBean.HEADERS_TYPE);
            for (Header header : this.headers) {
                headerTable.put(header.toCompositeData());
            }
            items.put("Headers", headerTable);
        }
        String[] allItemNames = BundleStateMBean.BUNDLE_TYPE.keySet().toArray(new String[0]);
        Object[] itemValues = new Object[allItemNames.length];
        for (int i = 0; i < allItemNames.length; ++i) {
            itemValues[i] = items.get(allItemNames[i]);
        }
        try {
            return new CompositeDataSupport(BundleStateMBean.BUNDLE_TYPE, allItemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Failed to create CompositeData for BundleData [" + this.identifier + "]", e);
        }
    }

    public static BundleData from(CompositeData compositeData) throws IllegalArgumentException {
        if (compositeData == null) {
            throw new IllegalArgumentException("Argument compositeData cannot be null");
        }
        if (!compositeData.getCompositeType().equals(BundleStateMBean.BUNDLE_TYPE)) {
            throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
        }
        BundleData bundleData = new BundleData();
        bundleData.exportedPackages = (String[])compositeData.get("ExportedPackages");
        bundleData.fragment = (Boolean)compositeData.get("Fragment");
        bundleData.fragments = TypeUtils.toPrimitive((Long[])((Long[])compositeData.get("Fragments")));
        bundleData.hosts = TypeUtils.toPrimitive((Long[])((Long[])compositeData.get("Hosts")));
        bundleData.identifier = (Long)compositeData.get("Identifier");
        bundleData.importedPackages = (String[])compositeData.get("ImportedPackages");
        bundleData.lastModified = (Long)compositeData.get("LastModified");
        bundleData.location = (String)compositeData.get("Location");
        bundleData.persistentlyStarted = (Boolean)compositeData.get("PersistentlyStarted");
        bundleData.registeredServices = TypeUtils.toPrimitive((Long[])((Long[])compositeData.get("RegisteredServices")));
        bundleData.removalPending = (Boolean)compositeData.get("RemovalPending");
        bundleData.required = (Boolean)compositeData.get("Required");
        bundleData.requiredBundles = TypeUtils.toPrimitive((Long[])((Long[])compositeData.get("RequiredBundles")));
        bundleData.requiringBundles = TypeUtils.toPrimitive((Long[])((Long[])compositeData.get("RequiringBundles")));
        bundleData.servicesInUse = TypeUtils.toPrimitive((Long[])((Long[])compositeData.get("ServicesInUse")));
        bundleData.bundleStartLevel = (Integer)compositeData.get("StartLevel");
        bundleData.state = (String)compositeData.get("State");
        bundleData.symbolicName = (String)compositeData.get("SymbolicName");
        bundleData.version = (String)compositeData.get("Version");
        TabularData headerTable = (TabularData)compositeData.get("Headers");
        Collection<?> headerData = headerTable.values();
        for (CompositeData headerRow : headerData) {
            bundleData.headers.add(Header.from(headerRow));
        }
        return bundleData;
    }

    public String[] getExportedPackages() {
        return this.exportedPackages;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public long[] getFragments() {
        return this.fragments;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public long[] getHosts() {
        return this.hosts;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public String[] getImportedPackages() {
        return this.importedPackages;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isPersistentlyStarted() {
        return this.persistentlyStarted;
    }

    public long[] getRegisteredServices() {
        return this.registeredServices;
    }

    public boolean isRemovalPending() {
        return this.removalPending;
    }

    public boolean isRequired() {
        return this.required;
    }

    public long[] getRequiredBundles() {
        return this.requiredBundles;
    }

    public long[] getRequiringBundles() {
        return this.requiringBundles;
    }

    public long[] getServicesInUse() {
        return this.servicesInUse;
    }

    public int getBundleStartLevel() {
        return this.bundleStartLevel;
    }

    public String getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public static class Header {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        private Header() {
        }

        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public CompositeData toCompositeData() throws JMRuntimeException {
            CompositeDataSupport result = null;
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("Key", this.key);
            items.put("Value", this.value);
            try {
                result = new CompositeDataSupport(BundleStateMBean.HEADER_TYPE, items);
            }
            catch (OpenDataException e) {
                throw new JMRuntimeException("Failed to create CompositeData for header [" + this.key + ":" + this.value + "] - " + e.getMessage());
            }
            return result;
        }

        public static Header from(CompositeData compositeData) {
            if (compositeData == null) {
                throw new IllegalArgumentException("Argument compositeData cannot be null");
            }
            if (!compositeData.getCompositeType().equals(BundleStateMBean.HEADER_TYPE)) {
                throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
            }
            Header header = new Header();
            header.key = (String)compositeData.get("Key");
            header.value = (String)compositeData.get("Value");
            return header;
        }
    }
}

