/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.PngText;
import org.apache.commons.imaging.formats.png.chunks.PngTextChunk;

public class PngChunkText
extends PngTextChunk {
    public final String keyword;
    public final String text;

    public PngChunkText(int length, int chunkType, int crc, byte[] bytes) throws ImageReadException, IOException {
        super(length, chunkType, crc, bytes);
        int index = BinaryFunctions.findNull(bytes);
        if (index < 0) {
            throw new ImageReadException("PNG tEXt chunk keyword is not terminated.");
        }
        this.keyword = new String(bytes, 0, index, "ISO-8859-1");
        int textLength = bytes.length - (index + 1);
        this.text = new String(bytes, index + 1, textLength, "ISO-8859-1");
        if (this.getDebug()) {
            System.out.println("Keyword: " + this.keyword);
            System.out.println("Text: " + this.text);
        }
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getText() {
        return this.text;
    }

    public PngText getContents() {
        return new PngText.Text(this.keyword, this.text);
    }
}

