/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import com.google.common.base.Objects;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheStatsMBean;
import org.apache.jackrabbit.oak.plugins.blob.UploadStagingCache;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;

class StagingCacheStats
extends AnnotatedStandardMBean
implements DataStoreCacheStatsMBean {
    private static final String HITS = "HITS";
    private static final String REQUESTS = "REQUESTS";
    private static final String UPLOAD_TIMER = "UPLOAD_TIMER";
    private static final String LOAD_SUCCESS = "CACHE_LOAD_SUCCESS";
    private static final String LOAD = "CACHE_LOAD";
    private static final String CURRENT_SIZE = "CURRENT_SIZE";
    private static final String CURRENT_MEM_SIZE = "CURRENT_MEM_SIZE";
    private static final String COUNT = "COUNT";
    private final String cacheName;
    private final long maxWeight;
    private final MeterStats hitMeter;
    private final MeterStats requestMeter;
    private final MeterStats loadSuccessMeter;
    private final MeterStats loadMeter;
    private final TimerStats uploadTimer;
    private final CounterStats currentSizeMeter;
    private final CounterStats currentMemSizeMeter;
    private final CounterStats countMeter;
    private final UploadStagingCache cache;

    StagingCacheStats(UploadStagingCache cache, StatisticsProvider provider, long maxWeight) {
        super(DataStoreCacheStatsMBean.class);
        this.cache = cache;
        StatisticsProvider statisticsProvider = provider;
        this.cacheName = "DataStore-StagingCache";
        this.maxWeight = maxWeight;
        String statName = StagingCacheStats.getStatName(HITS, this.cacheName);
        this.hitMeter = statisticsProvider.getMeter(statName, StatsOptions.METRICS_ONLY);
        statName = StagingCacheStats.getStatName(REQUESTS, this.cacheName);
        this.requestMeter = statisticsProvider.getMeter(statName, StatsOptions.METRICS_ONLY);
        statName = StagingCacheStats.getStatName(UPLOAD_TIMER, this.cacheName);
        this.uploadTimer = statisticsProvider.getTimer(statName, StatsOptions.METRICS_ONLY);
        statName = StagingCacheStats.getStatName(LOAD_SUCCESS, this.cacheName);
        this.loadSuccessMeter = statisticsProvider.getMeter(statName, StatsOptions.METRICS_ONLY);
        statName = StagingCacheStats.getStatName(LOAD, this.cacheName);
        this.loadMeter = statisticsProvider.getMeter(statName, StatsOptions.METRICS_ONLY);
        statName = StagingCacheStats.getStatName(CURRENT_SIZE, this.cacheName);
        this.currentSizeMeter = statisticsProvider.getCounterStats(statName, StatsOptions.METRICS_ONLY);
        statName = StagingCacheStats.getStatName(CURRENT_MEM_SIZE, this.cacheName);
        this.currentMemSizeMeter = statisticsProvider.getCounterStats(statName, StatsOptions.METRICS_ONLY);
        statName = StagingCacheStats.getStatName(COUNT, this.cacheName);
        this.countMeter = statisticsProvider.getCounterStats(statName, StatsOptions.METRICS_ONLY);
    }

    void markHit() {
        this.hitMeter.mark(1L);
    }

    void markRequest() {
        this.requestMeter.mark(1L);
    }

    void markLoadSuccess() {
        this.loadSuccessMeter.mark(1L);
    }

    void markLoad() {
        this.loadMeter.mark(1L);
    }

    TimerStats.Context startUpLoaderTimer() {
        return this.uploadTimer.time();
    }

    void incrementCount() {
        this.countMeter.inc(1L);
    }

    void incrementSize(long size) {
        this.currentSizeMeter.inc(size);
    }

    void incrementMemSize(long size) {
        this.currentMemSizeMeter.inc(size);
    }

    void decrementCount() {
        this.countMeter.dec(1L);
    }

    void decrementSize(long size) {
        this.currentSizeMeter.dec(size);
    }

    void decrementMemSize(int size) {
        this.currentMemSizeMeter.dec(size);
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public long getRequestCount() {
        return this.requestMeter.getCount();
    }

    @Override
    public long getHitCount() {
        return this.hitMeter.getCount();
    }

    @Override
    public double getHitRate() {
        long hitCount = this.hitMeter.getCount();
        long requestCount = this.requestMeter.getCount();
        return requestCount == 0L ? 0.0 : (double)hitCount / (double)requestCount;
    }

    @Override
    public long getMissCount() {
        return this.requestMeter.getCount() - this.hitMeter.getCount();
    }

    @Override
    public double getMissRate() {
        long missCount = this.getMissCount();
        long requestCount = this.requestMeter.getCount();
        return requestCount == 0L ? 0.0 : (double)missCount / (double)requestCount;
    }

    @Override
    public long getLoadCount() {
        return this.loadMeter.getCount();
    }

    @Override
    public long getLoadSuccessCount() {
        return this.loadSuccessMeter.getCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.getLoadCount() - this.getLoadSuccessCount();
    }

    @Override
    public double getLoadExceptionRate() {
        long loadExceptionCount = this.getLoadExceptionCount();
        long loadCount = this.loadMeter.getCount();
        return loadCount == 0L ? 0.0 : (double)loadExceptionCount / (double)loadCount;
    }

    @Override
    public long getElementCount() {
        return this.countMeter.getCount();
    }

    @Override
    public long getMaxTotalWeight() {
        return this.maxWeight;
    }

    @Override
    public long estimateCurrentWeight() {
        return this.currentSizeMeter.getCount();
    }

    @Override
    public long estimateCurrentMemoryWeight() {
        return this.currentMemSizeMeter.getCount();
    }

    @Override
    public String cacheInfoAsString() {
        return Objects.toStringHelper("StagingCacheStats").add("requestCount", this.getRequestCount()).add("hitCount", this.getHitCount()).add("hitRate", String.format("%1.2f", this.getHitRate())).add("missCount", this.getMissCount()).add("missRate", String.format("%1.2f", this.getMissRate())).add("loadCount", this.getLoadCount()).add("loadSuccessCount", this.getLoadSuccessCount()).add("elementCount", this.getElementCount()).add("currentMemSize", this.estimateCurrentMemoryWeight()).add("totalWeight", IOUtils.humanReadableByteCount(this.estimateCurrentWeight())).add("maxWeight", IOUtils.humanReadableByteCount(this.getMaxTotalWeight())).toString();
    }

    @Override
    public long getTotalLoadTime() {
        return 0L;
    }

    @Override
    public double getAverageLoadPenalty() {
        return 0.0;
    }

    @Override
    public long getEvictionCount() {
        return 0L;
    }

    @Override
    public void resetStats() {
    }

    private static String getStatName(String meter, String cacheName) {
        return cacheName + "." + meter;
    }
}

