/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocFieldProcessor;
import org.apache.lucene.index.DocInverter;
import org.apache.lucene.index.DocValuesProcessor;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NormsConsumer;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.StoredFieldsProcessor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TwoStoredFieldsConsumers;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.MutableBits;

class DocumentsWriterPerThread {
    static final IndexingChain defaultIndexingChain = new IndexingChain(){

        @Override
        DocConsumer getChain(DocumentsWriterPerThread documentsWriterPerThread) {
            TermVectorsConsumer termVectorsWriter = new TermVectorsConsumer(documentsWriterPerThread);
            FreqProxTermsWriter freqProxWriter = new FreqProxTermsWriter();
            TermsHash termsHash = new TermsHash(documentsWriterPerThread, freqProxWriter, true, new TermsHash(documentsWriterPerThread, termVectorsWriter, false, null));
            NormsConsumer normsWriter = new NormsConsumer();
            DocInverter docInverter = new DocInverter(documentsWriterPerThread.docState, termsHash, normsWriter);
            TwoStoredFieldsConsumers storedFields = new TwoStoredFieldsConsumers(new StoredFieldsProcessor(documentsWriterPerThread), new DocValuesProcessor(documentsWriterPerThread.bytesUsed));
            return new DocFieldProcessor(documentsWriterPerThread, docInverter, storedFields);
        }
    };
    private static final boolean INFO_VERBOSE = false;
    final Codec codec;
    final TrackingDirectoryWrapper directory;
    final Directory directoryOrig;
    final DocState docState;
    final DocConsumer consumer;
    final Counter bytesUsed;
    SegmentWriteState flushState;
    final BufferedUpdates pendingUpdates;
    private final SegmentInfo segmentInfo;
    boolean aborting = false;
    boolean hasAborted = false;
    private FieldInfos.Builder fieldInfos;
    private final InfoStream infoStream;
    private int numDocsInRAM;
    final DocumentsWriterDeleteQueue deleteQueue;
    private final DocumentsWriterDeleteQueue.DeleteSlice deleteSlice;
    private final NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
    final ByteBlockPool.Allocator byteBlockAllocator;
    final IntBlockPool.Allocator intBlockAllocator;
    private final LiveIndexWriterConfig indexWriterConfig;
    private final Set<String> filesToDelete = new HashSet<String>();
    static final int BYTE_BLOCK_NOT_MASK = Short.MIN_VALUE;
    static final int MAX_TERM_LENGTH_UTF8 = 32766;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(Set<String> createdFiles) {
        this.aborting = true;
        this.hasAborted = true;
        try {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "now abort");
            }
            try {
                this.consumer.abort();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pendingUpdates.clear();
            createdFiles.addAll(this.directory.getCreatedFiles());
        }
        finally {
            this.aborting = false;
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "done abort");
            }
        }
    }

    public DocumentsWriterPerThread(String segmentName, Directory directory, LiveIndexWriterConfig indexWriterConfig, InfoStream infoStream, DocumentsWriterDeleteQueue deleteQueue, FieldInfos.Builder fieldInfos) {
        this.directoryOrig = directory;
        this.directory = new TrackingDirectoryWrapper(directory);
        this.fieldInfos = fieldInfos;
        this.indexWriterConfig = indexWriterConfig;
        this.infoStream = infoStream;
        this.codec = indexWriterConfig.getCodec();
        this.docState = new DocState(this, infoStream);
        this.docState.similarity = indexWriterConfig.getSimilarity();
        this.bytesUsed = Counter.newCounter();
        this.byteBlockAllocator = new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed);
        this.pendingUpdates = new BufferedUpdates();
        this.intBlockAllocator = new IntBlockAllocator(this.bytesUsed);
        this.deleteQueue = deleteQueue;
        assert (this.numDocsInRAM == 0) : "num docs " + this.numDocsInRAM;
        this.pendingUpdates.clear();
        this.deleteSlice = deleteQueue.newSlice();
        this.segmentInfo = new SegmentInfo(this.directoryOrig, Constants.LUCENE_MAIN_VERSION, segmentName, -1, false, this.codec, null);
        assert (this.numDocsInRAM == 0);
        this.consumer = indexWriterConfig.getIndexingChain().getChain(this);
    }

    void setAborting() {
        this.aborting = true;
    }

    boolean checkAndResetHasAborted() {
        boolean retval = this.hasAborted;
        this.hasAborted = false;
        return retval;
    }

    final boolean testPoint(String message) {
        if (this.infoStream.isEnabled("TP")) {
            this.infoStream.message("TP", message);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Iterable<? extends IndexableField> doc, Analyzer analyzer, Term delTerm) throws IOException {
        assert (this.testPoint("DocumentsWriterPerThread addDocument start"));
        assert (this.deleteQueue != null);
        this.docState.doc = doc;
        this.docState.analyzer = analyzer;
        this.docState.docID = this.numDocsInRAM++;
        boolean success = false;
        try {
            try {
                this.consumer.processDocument(this.fieldInfos);
            }
            finally {
                this.docState.clear();
            }
            success = true;
        }
        finally {
            if (!success) {
                if (!this.aborting) {
                    this.deleteDocID(this.docState.docID);
                } else {
                    this.abort(this.filesToDelete);
                }
            }
        }
        success = false;
        try {
            this.consumer.finishDocument();
            success = true;
        }
        finally {
            if (!success) {
                this.abort(this.filesToDelete);
            }
        }
        this.finishDocument(delTerm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs, Analyzer analyzer, Term delTerm) throws IOException {
        assert (this.testPoint("DocumentsWriterPerThread addDocuments start"));
        assert (this.deleteQueue != null);
        this.docState.analyzer = analyzer;
        int docCount = 0;
        boolean allDocsIndexed = false;
        try {
            for (Iterable<? extends IndexableField> iterable : docs) {
                this.docState.doc = iterable;
                this.docState.docID = this.numDocsInRAM++;
                ++docCount;
                boolean success = false;
                try {
                    this.consumer.processDocument(this.fieldInfos);
                    success = true;
                }
                finally {
                    if (!success && this.aborting) {
                        this.abort(this.filesToDelete);
                    }
                }
                success = false;
                try {
                    this.consumer.finishDocument();
                    success = true;
                }
                finally {
                    if (!success) {
                        this.abort(this.filesToDelete);
                    }
                }
                this.finishDocument(null);
            }
            allDocsIndexed = true;
            if (delTerm != null) {
                this.deleteQueue.add(delTerm, this.deleteSlice);
                assert (this.deleteSlice.isTailItem(delTerm)) : "expected the delete term as the tail item";
                this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM - docCount);
            }
        }
        finally {
            if (!allDocsIndexed && !this.aborting) {
                int docID;
                int n = docID - docCount;
                for (docID = this.numDocsInRAM - 1; docID > n; --docID) {
                    this.deleteDocID(docID);
                }
            }
            this.docState.clear();
        }
        return docCount;
    }

    private void finishDocument(Term delTerm) {
        boolean applySlice;
        boolean bl = applySlice = this.numDocsInRAM != 0;
        if (delTerm != null) {
            this.deleteQueue.add(delTerm, this.deleteSlice);
            assert (this.deleteSlice.isTailItem(delTerm)) : "expected the delete term as the tail item";
        } else {
            applySlice &= this.deleteQueue.updateSlice(this.deleteSlice);
        }
        if (applySlice) {
            this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM);
        } else {
            this.deleteSlice.reset();
        }
        ++this.numDocsInRAM;
    }

    void deleteDocID(int docIDUpto) {
        this.pendingUpdates.addDocID(docIDUpto);
    }

    public int numDeleteTerms() {
        return this.pendingUpdates.numTermDeletes.get();
    }

    public int getNumDocsInRAM() {
        return this.numDocsInRAM;
    }

    FrozenBufferedUpdates prepareFlush() {
        assert (this.numDocsInRAM > 0);
        FrozenBufferedUpdates globalUpdates = this.deleteQueue.freezeGlobalBuffer(this.deleteSlice);
        if (this.deleteSlice != null) {
            this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM);
            assert (this.deleteSlice.isEmpty());
            this.deleteSlice.reset();
        }
        return globalUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FlushedSegment flush() throws IOException {
        assert (this.numDocsInRAM > 0);
        assert (this.deleteSlice.isEmpty()) : "all deletes must be applied in prepareFlush";
        this.segmentInfo.setDocCount(this.numDocsInRAM);
        SegmentWriteState flushState = new SegmentWriteState(this.infoStream, this.directory, this.segmentInfo, this.fieldInfos.finish(), this.indexWriterConfig.getTermIndexInterval(), this.pendingUpdates, new IOContext(new FlushInfo(this.numDocsInRAM, this.bytesUsed())));
        double startMBUsed = (double)this.bytesUsed() / 1024.0 / 1024.0;
        if (this.pendingUpdates.docIDs.size() > 0) {
            flushState.liveDocs = this.codec.liveDocsFormat().newLiveDocs(this.numDocsInRAM);
            for (int delDocID : this.pendingUpdates.docIDs) {
                flushState.liveDocs.clear(delDocID);
            }
            flushState.delCountOnFlush = this.pendingUpdates.docIDs.size();
            this.pendingUpdates.bytesUsed.addAndGet(-this.pendingUpdates.docIDs.size() * BufferedUpdates.BYTES_PER_DEL_DOCID);
            this.pendingUpdates.docIDs.clear();
        }
        if (this.aborting) {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "flush: skip because aborting is set");
            }
            return null;
        }
        if (this.infoStream.isEnabled("DWPT")) {
            this.infoStream.message("DWPT", "flush postings as segment " + flushState.segmentInfo.name + " numDocs=" + this.numDocsInRAM);
        }
        boolean success = false;
        try {
            BufferedUpdates segmentDeletes;
            this.consumer.flush(flushState);
            this.pendingUpdates.terms.clear();
            this.segmentInfo.setFiles(new HashSet<String>(this.directory.getCreatedFiles()));
            SegmentCommitInfo segmentInfoPerCommit = new SegmentCommitInfo(this.segmentInfo, 0, -1L, -1L);
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "new segment has " + (flushState.liveDocs == null ? 0 : flushState.segmentInfo.getDocCount() - flushState.delCountOnFlush) + " deleted docs");
                this.infoStream.message("DWPT", "new segment has " + (flushState.fieldInfos.hasVectors() ? "vectors" : "no vectors") + "; " + (flushState.fieldInfos.hasNorms() ? "norms" : "no norms") + "; " + (flushState.fieldInfos.hasDocValues() ? "docValues" : "no docValues") + "; " + (flushState.fieldInfos.hasProx() ? "prox" : "no prox") + "; " + (flushState.fieldInfos.hasFreq() ? "freqs" : "no freqs"));
                this.infoStream.message("DWPT", "flushedFiles=" + segmentInfoPerCommit.files());
                this.infoStream.message("DWPT", "flushed codec=" + this.codec);
            }
            if (this.pendingUpdates.queries.isEmpty() && this.pendingUpdates.numericUpdates.isEmpty()) {
                this.pendingUpdates.clear();
                segmentDeletes = null;
            } else {
                segmentDeletes = this.pendingUpdates;
            }
            if (this.infoStream.isEnabled("DWPT")) {
                double newSegmentSize = (double)segmentInfoPerCommit.sizeInBytes() / 1024.0 / 1024.0;
                this.infoStream.message("DWPT", "flushed: segment=" + this.segmentInfo.name + " ramUsed=" + this.nf.format(startMBUsed) + " MB" + " newFlushedSize(includes docstores)=" + this.nf.format(newSegmentSize) + " MB" + " docs/MB=" + this.nf.format((double)flushState.segmentInfo.getDocCount() / newSegmentSize));
            }
            assert (this.segmentInfo != null);
            FlushedSegment fs = new FlushedSegment(segmentInfoPerCommit, flushState.fieldInfos, segmentDeletes, flushState.liveDocs, flushState.delCountOnFlush);
            this.sealFlushedSegment(fs);
            success = true;
            FlushedSegment flushedSegment = fs;
            return flushedSegment;
        }
        finally {
            if (!success) {
                this.abort(this.filesToDelete);
            }
        }
    }

    public Set<String> pendingFilesToDelete() {
        return this.filesToDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sealFlushedSegment(FlushedSegment flushedSegment) throws IOException {
        assert (flushedSegment != null);
        SegmentCommitInfo newSegment = flushedSegment.segmentInfo;
        IndexWriter.setDiagnostics(newSegment.info, "flush");
        IOContext context = new IOContext(new FlushInfo(newSegment.info.getDocCount(), newSegment.sizeInBytes()));
        boolean success = false;
        try {
            if (this.indexWriterConfig.getUseCompoundFile()) {
                this.filesToDelete.addAll(IndexWriter.createCompoundFile(this.infoStream, this.directory, MergeState.CheckAbort.NONE, newSegment.info, context));
                newSegment.info.setUseCompoundFile(true);
            }
            this.codec.segmentInfoFormat().getSegmentInfoWriter().write(this.directory, newSegment.info, flushedSegment.fieldInfos, context);
            if (flushedSegment.liveDocs != null) {
                int delCount = flushedSegment.delCount;
                assert (delCount > 0);
                if (this.infoStream.isEnabled("DWPT")) {
                    this.infoStream.message("DWPT", "flush: write " + delCount + " deletes gen=" + flushedSegment.segmentInfo.getDelGen());
                }
                SegmentCommitInfo info = flushedSegment.segmentInfo;
                Codec codec = info.info.getCodec();
                codec.liveDocsFormat().writeLiveDocs(flushedSegment.liveDocs, this.directory, info, delCount, context);
                newSegment.setDelCount(delCount);
                newSegment.advanceDelGen();
            }
            success = true;
        }
        finally {
            if (!success && this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "hit exception creating compound file for newly flushed segment " + newSegment.info.name);
            }
        }
    }

    SegmentInfo getSegmentInfo() {
        return this.segmentInfo;
    }

    long bytesUsed() {
        return this.bytesUsed.get() + this.pendingUpdates.bytesUsed.get();
    }

    public String toString() {
        return "DocumentsWriterPerThread [pendingDeletes=" + this.pendingUpdates + ", segment=" + (this.segmentInfo != null ? this.segmentInfo.name : "null") + ", aborting=" + this.aborting + ", numDocsInRAM=" + this.numDocsInRAM + ", deleteQueue=" + this.deleteQueue + "]";
    }

    private static class IntBlockAllocator
    extends IntBlockPool.Allocator {
        private final Counter bytesUsed;

        public IntBlockAllocator(Counter bytesUsed) {
            super(8192);
            this.bytesUsed = bytesUsed;
        }

        @Override
        public int[] getIntBlock() {
            int[] b = new int[8192];
            this.bytesUsed.addAndGet(32768L);
            return b;
        }

        @Override
        public void recycleIntBlocks(int[][] blocks, int offset, int length) {
            this.bytesUsed.addAndGet(-(length * 32768));
        }
    }

    static class FlushedSegment {
        final SegmentCommitInfo segmentInfo;
        final FieldInfos fieldInfos;
        final FrozenBufferedUpdates segmentUpdates;
        final MutableBits liveDocs;
        final int delCount;

        private FlushedSegment(SegmentCommitInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates segmentUpdates, MutableBits liveDocs, int delCount) {
            this.segmentInfo = segmentInfo;
            this.fieldInfos = fieldInfos;
            this.segmentUpdates = segmentUpdates != null && segmentUpdates.any() ? new FrozenBufferedUpdates(segmentUpdates, true) : null;
            this.liveDocs = liveDocs;
            this.delCount = delCount;
        }
    }

    static class DocState {
        final DocumentsWriterPerThread docWriter;
        Analyzer analyzer;
        InfoStream infoStream;
        Similarity similarity;
        int docID;
        Iterable<? extends IndexableField> doc;
        String maxTermPrefix;

        DocState(DocumentsWriterPerThread docWriter, InfoStream infoStream) {
            this.docWriter = docWriter;
            this.infoStream = infoStream;
        }

        public boolean testPoint(String name) {
            return this.docWriter.testPoint(name);
        }

        public void clear() {
            this.doc = null;
            this.analyzer = null;
        }
    }

    static abstract class IndexingChain {
        IndexingChain() {
        }

        abstract DocConsumer getChain(DocumentsWriterPerThread var1);
    }
}

