/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.atom.taglib.media;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.abdera.ext.media.MediaConstants;
import org.apache.abdera.ext.media.MediaContent;
import org.apache.abdera.ext.media.MediaGroup;
import org.apache.abdera.model.Entry;
import org.apache.sling.atom.taglib.AbstractAbderaHandler;

public class MediaContentTagHandler
extends AbstractAbderaHandler {
    private static final long serialVersionUID = 1L;
    private String url;
    private long fileSize;
    private String type;
    private String medium;
    private String isDefault;
    private String expression;
    private int bitrate;
    private double samplingrate;
    private int framerate;
    private int channels;
    private int duration;
    private int height;
    private int width;

    public int doEndTag() throws JspException {
        ServletRequest request = this.pageContext.getRequest();
        request.setAttribute("content", null);
        return super.doEndTag();
    }

    public int doStartTag() {
        MediaContent content;
        ServletRequest request = this.pageContext.getRequest();
        if (request.getAttribute("group") instanceof MediaGroup) {
            MediaGroup group = (MediaGroup)request.getAttribute("group");
            content = (MediaContent)group.addExtension(MediaConstants.CONTENT);
        } else {
            Entry entry = this.getEntry();
            content = (MediaContent)entry.addExtension(MediaConstants.CONTENT);
        }
        if (this.url != null) {
            content.setUrl(this.url.replaceAll(" ", "%20"));
        }
        if (this.fileSize != 0L) {
            content.setFilesize(this.fileSize);
        }
        if (this.type != null) {
            content.setType(this.type);
        }
        if (this.medium != null) {
            content.setMedium(MediaConstants.Medium.valueOf(this.medium));
        }
        if (this.expression != null) {
            content.setExpression(MediaConstants.Expression.valueOf(this.expression));
        }
        if (this.bitrate != 0) {
            content.setBitrate(this.bitrate);
        }
        if (this.samplingrate != 0.0) {
            content.setSamplingRate(this.samplingrate);
        }
        if (this.framerate != 0) {
            content.setFramerate(this.framerate);
        }
        if (this.channels != 0) {
            content.setChannels(this.channels);
        }
        if (this.duration != 0) {
            content.setDuration(this.duration);
        }
        if (this.height != 0) {
            content.setHeight(this.height);
        }
        if (this.width != 0) {
            content.setWidth(this.width);
        }
        request.setAttribute("content", content);
        return 1;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public double getSamplingrate() {
        return this.samplingrate;
    }

    public void setSamplingrate(double samplingrate) {
        this.samplingrate = samplingrate;
    }

    public int getFramerate() {
        return this.framerate;
    }

    public void setFramerate(int framerate) {
        this.framerate = framerate;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

