/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.auth.core.AuthUtil;

public abstract class AbstractAuthenticationFormServlet
extends HttpServlet {
    public static final String DEFAULT_FORM_PATH = "login.html";
    public static final String CUSTOM_FORM_PATH = "custom_login.html";
    private volatile String rawForm;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handle(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handle(request, response);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.reset();
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        response.getWriter().print(this.getForm(request));
        response.flushBuffer();
    }

    protected String getForm(HttpServletRequest request) throws IOException {
        String form = this.getRawForm();
        String resource = AbstractAuthenticationFormServlet.cleanse(request, this.getResource(request));
        String reason = this.getReason(request);
        String resourceContextPath = AbstractAuthenticationFormServlet.cleanse(request, this.getContextPath(request));
        String contextPath = request.getContextPath();
        form = form.replace("${resource}", AbstractAuthenticationFormServlet.escape(resource));
        form = form.replace("${j_reason}", AbstractAuthenticationFormServlet.escape(reason));
        form = form.replace("${requestContextPath}", AbstractAuthenticationFormServlet.escape(resourceContextPath));
        form = form.replace("${contextPath}", AbstractAuthenticationFormServlet.escape(contextPath));
        return form;
    }

    private static String cleanse(HttpServletRequest request, String target) {
        if (target.length() > 0 && !AuthUtil.isRedirectValid(request, target)) {
            return "";
        }
        return target;
    }

    private static String escape(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("%22");
                continue;
            }
            if (c == '\'') {
                b.append("%27");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    protected String getResource(HttpServletRequest request) {
        return AuthUtil.getLoginResource(request, "");
    }

    protected abstract String getReason(HttpServletRequest var1);

    protected String getContextPath(HttpServletRequest request) {
        int query;
        String contextPath = this.getResource(request);
        if ("".equals(contextPath)) {
            contextPath = request.getContextPath();
        }
        if ((query = contextPath.indexOf(63)) > 0) {
            contextPath = contextPath.substring(0, query);
        }
        return AbstractAuthenticationFormServlet.removeEndingSlash(contextPath);
    }

    private static String removeEndingSlash(String str) {
        if (str != null && str.endsWith("/")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRawForm() throws IOException {
        if (this.rawForm == null) {
            InputStream ins = null;
            try {
                ins = this.getClass().getResourceAsStream(this.getCustomFormPath());
                if (ins == null) {
                    ins = this.getClass().getResourceAsStream(this.getDefaultFormPath());
                }
                if (ins != null) {
                    StringBuilder builder = new StringBuilder();
                    InputStreamReader r = new InputStreamReader(ins, "UTF-8");
                    char[] cbuf = new char[1024];
                    int rd = 0;
                    while ((rd = r.read(cbuf)) >= 0) {
                        builder.append(cbuf, 0, rd);
                    }
                    this.rawForm = builder.toString();
                }
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (this.rawForm == null) {
                throw new IOException("Failed reading form template");
            }
        }
        return this.rawForm;
    }

    protected String getDefaultFormPath() {
        return DEFAULT_FORM_PATH;
    }

    protected String getCustomFormPath() {
        return CUSTOM_FORM_PATH;
    }
}

