/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ctakes;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.tika.parser.ctakes.CTAKESAnnotationProperty;
import org.apache.tika.parser.ctakes.CTAKESSerializer;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XmlCasSerializer;
import org.xml.sax.SAXException;

public class CTAKESUtils {
    private static final String CTAKES_UMLS_USER = "ctakes.umlsuser";
    private static final String CTAKES_UMLS_PASS = "ctakes.umlspw";

    public static AnalysisEngine getAnalysisEngine(String aeDescriptor, String umlsUser, String umlsPass) throws IOException, InvalidXMLException, ResourceInitializationException, URISyntaxException {
        String aeDescriptorPath = CTAKESUtils.class.getResource(aeDescriptor).toURI().getPath();
        XMLInputSource aeIputSource = new XMLInputSource(aeDescriptorPath);
        ResourceSpecifier aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(aeIputSource);
        if (umlsUser != null && !umlsUser.isEmpty() && umlsPass != null && !umlsPass.isEmpty()) {
            System.setProperty(CTAKES_UMLS_USER, umlsUser);
            System.setProperty(CTAKES_UMLS_PASS, umlsPass);
        }
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aeSpecifier);
        return ae;
    }

    public static JCas getJCas(AnalysisEngine ae) throws ResourceInitializationException {
        JCas jcas = ae.newJCas();
        return jcas;
    }

    public static void serialize(JCas jcas, CTAKESSerializer type, boolean prettyPrint, OutputStream stream) throws SAXException, IOException {
        if (type == CTAKESSerializer.XCAS) {
            XCASSerializer.serialize((CAS)jcas.getCas(), (OutputStream)stream, (boolean)prettyPrint);
        } else if (type == CTAKESSerializer.XMI) {
            XmiCasSerializer.serialize((CAS)jcas.getCas(), (TypeSystem)jcas.getTypeSystem(), (OutputStream)stream, (boolean)prettyPrint, (XmiSerializationSharedData)new XmiSerializationSharedData());
        } else {
            XmlCasSerializer.serialize((CAS)jcas.getCas(), (TypeSystem)jcas.getTypeSystem(), (OutputStream)stream);
        }
    }

    public static String getAnnotationProperty(IdentifiedAnnotation annotation, CTAKESAnnotationProperty property) {
        String value = null;
        if (property == CTAKESAnnotationProperty.BEGIN) {
            value = Integer.toString(annotation.getBegin());
        } else if (property == CTAKESAnnotationProperty.END) {
            value = Integer.toString(annotation.getEnd());
        } else if (property == CTAKESAnnotationProperty.CONDITIONAL) {
            value = Boolean.toString(annotation.getConditional());
        } else if (property == CTAKESAnnotationProperty.CONFIDENCE) {
            value = Float.toString(annotation.getConfidence());
        } else if (property == CTAKESAnnotationProperty.DISCOVERY_TECNIQUE) {
            value = Integer.toString(annotation.getDiscoveryTechnique());
        } else if (property == CTAKESAnnotationProperty.GENERIC) {
            value = Boolean.toString(annotation.getGeneric());
        } else if (property == CTAKESAnnotationProperty.HISTORY_OF) {
            value = Integer.toString(annotation.getHistoryOf());
        } else if (property == CTAKESAnnotationProperty.ID) {
            value = Integer.toString(annotation.getId());
        } else if (property == CTAKESAnnotationProperty.ONTOLOGY_CONCEPT_ARR) {
            FSArray mentions = annotation.getOntologyConceptArr();
            StringBuilder sb = new StringBuilder();
            if (mentions != null) {
                for (int i = 0; i < mentions.size(); ++i) {
                    if (!(mentions.get(i) instanceof UmlsConcept)) continue;
                    UmlsConcept concept = (UmlsConcept)mentions.get(i);
                    sb.append("cui=").append(concept.getCui()).append(",").append(concept.getCodingScheme()).append("=").append(concept.getCode());
                    if (i >= mentions.size() - 1) continue;
                    sb.append(",");
                }
            }
            value = sb.toString();
        } else if (property == CTAKESAnnotationProperty.POLARITY) {
            String polarity_pref = "POLARITY";
            value = polarity_pref + "=" + Integer.toString(annotation.getPolarity());
        }
        return value;
    }

    public static void reset(AnalysisEngine ae, JCas jcas) {
        CTAKESUtils.resetAE(ae);
        CTAKESUtils.resetCAS(jcas);
        jcas = null;
    }

    public static void resetCAS(JCas jcas) {
        if (jcas != null) {
            jcas.reset();
        }
    }

    public static void resetAE(AnalysisEngine ae) {
        if (ae != null) {
            ae.destroy();
            ae = null;
        }
    }
}

