/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.parser.microsoft.ooxml.ParagraphProperties;
import org.apache.tika.parser.microsoft.ooxml.RunProperties;
import org.apache.tika.parser.microsoft.ooxml.XWPFListManager;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XWPFEventBasedWordExtractor
extends POIXMLTextExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(XWPFEventBasedWordExtractor.class);
    private OPCPackage container;
    private POIXMLProperties properties;

    public XWPFEventBasedWordExtractor(String path) throws XmlException, OpenXML4JException, IOException {
        this(OPCPackage.open(path));
    }

    public XWPFEventBasedWordExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        super((POIXMLDocument)null);
        this.container = container;
        this.properties = new POIXMLProperties(container);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XWPFEventBasedWordExtractor <filename.xlsx>");
            System.exit(1);
        }
        XWPFEventBasedWordExtractor extractor = new XWPFEventBasedWordExtractor(args[0]);
        System.out.println(extractor.getText());
        extractor.close();
    }

    public OPCPackage getPackage() {
        return this.container;
    }

    public POIXMLProperties.CoreProperties getCoreProperties() {
        return this.properties.getCoreProperties();
    }

    public POIXMLProperties.ExtendedProperties getExtendedProperties() {
        return this.properties.getExtendedProperties();
    }

    public POIXMLProperties.CustomProperties getCustomProperties() {
        return this.properties.getCustomProperties();
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        ArrayList<PackagePart> pps = this.container.getPartsByContentType(XWPFRelation.DOCUMENT.getContentType());
        if (pps != null) {
            for (PackagePart pp : pps) {
                try {
                    this.handleDocumentPart(pp, sb);
                }
                catch (IOException e) {
                    LOG.warn("IOException handling document part", e);
                }
                catch (SAXException e) {
                    LOG.warn("SAXException handling document part", e);
                }
            }
        }
        if ((pps = this.container.getPartsByContentType(XWPFRelation.GLOSSARY_DOCUMENT.getContentType())) != null) {
            for (PackagePart pp : pps) {
                try {
                    this.handleDocumentPart(pp, sb);
                }
                catch (IOException e) {
                    LOG.warn("IOException handling glossary document part", e);
                }
                catch (SAXException e) {
                    LOG.warn("SAXException handling glossary document part", e);
                }
            }
        }
        return sb.toString();
    }

    private void handleDocumentPart(PackagePart documentPart, StringBuilder sb) throws IOException, SAXException {
        XWPFNumbering numbering = this.loadNumbering(documentPart);
        XWPFListManager xwpfListManager = new XWPFListManager(numbering);
        try {
            PackageRelationshipCollection headersPRC = documentPart.getRelationshipsByType(XWPFRelation.HEADER.getRelation());
            if (headersPRC != null) {
                for (int i = 0; i < headersPRC.size(); ++i) {
                    PackagePart header = documentPart.getRelatedPart(headersPRC.getRelationship(i));
                    this.handlePart(header, xwpfListManager, sb);
                }
            }
        }
        catch (InvalidFormatException e) {
            LOG.warn("Invalid format", e);
        }
        this.handlePart(documentPart, xwpfListManager, sb);
        for (XWPFRelation rel : new XWPFRelation[]{XWPFRelation.FOOTNOTE, XWPFRelation.COMMENT, XWPFRelation.FOOTER, XWPFRelation.ENDNOTE}) {
            try {
                PackageRelationshipCollection prc = documentPart.getRelationshipsByType(rel.getRelation());
                if (prc == null) continue;
                for (int i = 0; i < prc.size(); ++i) {
                    PackagePart packagePart = documentPart.getRelatedPart(prc.getRelationship(i));
                    this.handlePart(packagePart, xwpfListManager, sb);
                }
            }
            catch (InvalidFormatException e) {
                LOG.warn("Invalid format", e);
            }
        }
    }

    private void handlePart(PackagePart packagePart, XWPFListManager xwpfListManager, StringBuilder buffer) throws IOException, SAXException {
        Map<String, String> hyperlinks = this.loadHyperlinkRelationships(packagePart);
        try (InputStream stream = packagePart.getInputStream();){
            XMLReader reader = SAXHelper.newXMLReader();
            reader.setContentHandler(new OOXMLWordAndPowerPointTextHandler(new XWPFToTextContentHandler(buffer), hyperlinks));
            reader.parse(new InputSource(new CloseShieldInputStream(stream)));
        }
        catch (ParserConfigurationException e) {
            LOG.warn("Can't configure XMLReader", e);
        }
    }

    private Map<String, String> loadHyperlinkRelationships(PackagePart bodyPart) {
        HashMap<String, String> hyperlinks = new HashMap<String, String>();
        try {
            PackageRelationshipCollection prc = bodyPart.getRelationshipsByType(XWPFRelation.HYPERLINK.getRelation());
            for (int i = 0; i < prc.size(); ++i) {
                String url;
                PackageRelationship pr = prc.getRelationship(i);
                if (pr == null) continue;
                String id = pr.getId();
                String string = url = pr.getTargetURI() == null ? null : pr.getTargetURI().toString();
                if (id == null || url == null) continue;
                hyperlinks.put(id, url);
            }
        }
        catch (InvalidFormatException e) {
            LOG.warn("Invalid format", e);
        }
        return hyperlinks;
    }

    private XWPFNumbering loadNumbering(PackagePart packagePart) {
        try {
            PackageRelationshipCollection numberingParts = packagePart.getRelationshipsByType(XWPFRelation.NUMBERING.getRelation());
            if (numberingParts.size() > 0) {
                PackageRelationship numberingRelationShip = numberingParts.getRelationship(0);
                if (numberingRelationShip == null) {
                    return null;
                }
                PackagePart numberingPart = this.container.getPart(numberingRelationShip);
                if (numberingPart == null) {
                    return null;
                }
                return new XWPFNumbering(numberingPart);
            }
        }
        catch (OpenXML4JException e) {
            LOG.warn("Couldn't load numbering", e);
        }
        return null;
    }

    private class XWPFToTextContentHandler
    implements OOXMLWordAndPowerPointTextHandler.XWPFBodyContentsHandler {
        private final StringBuilder buffer;

        public XWPFToTextContentHandler(StringBuilder buffer) {
            this.buffer = buffer;
        }

        @Override
        public void run(RunProperties runProperties, String contents) {
            this.buffer.append(contents);
        }

        @Override
        public void hyperlinkStart(String link) {
        }

        @Override
        public void hyperlinkEnd() {
        }

        @Override
        public void startParagraph(ParagraphProperties paragraphProperties) {
        }

        @Override
        public void endParagraph() {
            this.buffer.append("\n");
        }

        @Override
        public void startTable() {
        }

        @Override
        public void endTable() {
        }

        @Override
        public void startTableRow() {
        }

        @Override
        public void endTableRow() {
            this.buffer.append("\n");
        }

        @Override
        public void startTableCell() {
        }

        @Override
        public void endTableCell() {
            this.buffer.append("\t");
        }

        @Override
        public void startSDT() {
        }

        @Override
        public void endSDT() {
            this.buffer.append("\n");
        }

        @Override
        public void startEditedSection(String editor, Date date, OOXMLWordAndPowerPointTextHandler.EditType editType) {
        }

        @Override
        public void endEditedSection() {
        }

        @Override
        public boolean getIncludeDeletedText() {
            return true;
        }

        @Override
        public void footnoteReference(String id) {
        }

        @Override
        public void endnoteReference(String id) {
        }

        @Override
        public boolean getIncludeMoveFromText() {
            return false;
        }

        @Override
        public void embeddedOLERef(String refId) {
        }

        @Override
        public void embeddedPicRef(String picFileName, String picDescription) {
        }

        @Override
        public void startBookmark(String id, String name) {
        }

        @Override
        public void endBookmark(String id) {
        }
    }
}

