/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.formsndocuments.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(TemplateUtils.class);

    public static List<Resource> getConfigurations(ResourceResolver resolver) {
        ArrayList<Resource> configurations = new ArrayList<Resource>();
        String pathExpression = "/conf/%/settings/wcm/templates".replaceAll("'", "''");
        String sql = "SELECT * FROM [cq:Page] AS p WHERE ISDESCENDANTNODE([/conf]) AND p.[jcr:path] LIKE '" + pathExpression + "' ORDER BY [jcr:path]";
        Iterator<Resource> iterator = resolver.findResources(sql, "JCR-SQL2");
        while (iterator.hasNext()) {
            Resource templates = iterator.next();
            String path = templates.getPath();
            String configurationPath = path.substring(0, path.length() - "settings/wcm/templates".length());
            Resource configuration = resolver.getResource(configurationPath);
            if (configuration == null) {
                configuration = templates;
            }
            configurations.add(configuration);
        }
        return configurations;
    }

    public static List<Resource> getValidICTemplates(Resource confResource, String assetPathSuffix) {
        Resource templates;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (confResource != null && (templates = confResource.getChild("settings/wcm/templates")) != null) {
            for (Resource templateResource : templates.getChildren()) {
                if (!TemplateUtils.isValidICTemplate(templateResource, assetPathSuffix)) continue;
                resources.add(templateResource);
            }
        }
        return resources;
    }

    public static List<Resource> getFilteredAFTemplates(Iterator<Resource> it, String assetPathSuffix) {
        List templatesList = IteratorUtils.toList(it);
        ArrayList tempTemplatesList = new ArrayList(templatesList);
        for (Resource tempRes : tempTemplatesList) {
            Node tempNode = tempRes.adaptTo(Node.class);
            try {
                if (tempNode == null || !tempNode.hasNode("jcr:content") || TemplateUtils.isTemplateAllowed(tempNode.getNode("jcr:content"), assetPathSuffix)) continue;
                templatesList.remove(tempRes);
            }
            catch (RepositoryException e) {
                log.error("Exception occured in getFilteredAFTemplates function while fetching jcr:content from : " + tempNode, e);
            }
        }
        return templatesList;
    }

    public static List<Resource> findTemplates(ResourceResolver resolver, String title, String assetPathSuffix) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String sql = "SELECT * FROM [cq:Template] AS t WHERE lower(t.[jcr:title]) LIKE '%" + title + "%' OR lower(t.[jcr:content/jcr:title]) LIKE '%" + title + "%' ORDER BY [jcr:path]";
        Iterator<Resource> iterator = resolver.findResources(sql, "JCR-SQL2");
        while (iterator.hasNext()) {
            Resource resource = iterator.next();
            if (!TemplateUtils.isValidICTemplate(resource, assetPathSuffix)) continue;
            resources.add(resource);
        }
        return resources;
    }

    private static boolean isValidICTemplate(Resource templateResource, String assetPathSuffix) {
        boolean isValid = false;
        Node tempNode = templateResource.adaptTo(Node.class);
        try {
            Node jcrContentNode;
            if (tempNode != null && tempNode.hasNode("jcr:content") && (jcrContentNode = tempNode.getNode("jcr:content")) != null && TemplateUtils.isTemplateAllowed(jcrContentNode, assetPathSuffix) && jcrContentNode.hasProperty("status") && "enabled".equals(jcrContentNode.getProperty("status").getString()) && tempNode.hasNode("initial/jcr:content") && (jcrContentNode = tempNode.getNode("initial/jcr:content")) != null && jcrContentNode.hasProperty("guideComponentType") && "fd/ccm/web-channel/templates".equals(jcrContentNode.getProperty("guideComponentType").getString())) {
                isValid = true;
            }
        }
        catch (RepositoryException e) {
            log.error("Exception occured in isValidICTemplate function while reading : " + tempNode, e);
        }
        return isValid;
    }

    public static boolean isTemplateAllowed(@Nonnull Session session, String templatePath, String assetPathSuffix) {
        boolean isAllowed = false;
        try {
            Node templateNode;
            if (session.nodeExists(templatePath) && (templateNode = session.getNode(templatePath)) != null && templateNode.hasNode("jcr:content")) {
                isAllowed = TemplateUtils.isTemplateAllowed(templateNode.getNode("jcr:content"), assetPathSuffix);
            }
        }
        catch (RepositoryException e) {
            log.error("Exception occured in isTemplateAllowed function while reading node from : " + templatePath, e);
        }
        return isAllowed;
    }

    private static boolean isTemplateAllowed(Node node, String assetPathSuffix) {
        boolean isAllowed;
        block4: {
            isAllowed = false;
            try {
                if (node != null && node.hasProperty("allowedPaths")) {
                    Value[] allowedPathValues;
                    for (Value v : allowedPathValues = node.getProperty("allowedPaths").getValues()) {
                        if (!StringUtils.isEmpty(v.getString()) && (assetPathSuffix == null || !assetPathSuffix.matches(v.getString()))) continue;
                        isAllowed = true;
                        break block4;
                    }
                    break block4;
                }
                isAllowed = true;
            }
            catch (RepositoryException e) {
                log.error("Exception occured in isTemplateAllowed function while fetching allowed path property from : " + node, e);
            }
        }
        return isAllowed;
    }
}

