/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.cache;

import com.adobe.aemds.guide.cache.CacheObject;
import com.adobe.aemds.guide.cache.api.CacheStore;
import java.util.Calendar;

public class Cache {
    private CacheStore cacheStore;

    public Cache(CacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }

    public Object put(Object key, Object value, Calendar modifiedTime) {
        if (modifiedTime == null || modifiedTime.getTimeInMillis() != Long.MAX_VALUE) {
            CacheObject cacheObject = new CacheObject(value, modifiedTime);
            return this.cacheStore.put(key, cacheObject);
        }
        return null;
    }

    public Object get(Object key) {
        CacheObject cacheObject = this.cacheStore.get(key);
        if (cacheObject == null) {
            return null;
        }
        return cacheObject.getCacheObject();
    }

    public void clearAll() {
        this.cacheStore.clearAll();
    }

    public void clear(String key) {
        this.cacheStore.clear(key);
    }

    public boolean isCacheEntryStale(Object key, Calendar updateTime) {
        if (!this.cacheStore.entryExists(key)) {
            return true;
        }
        if (updateTime == null) {
            return false;
        }
        CacheObject cacheObject = this.cacheStore.get(key);
        return cacheObject.getLastModifiedTime().compareTo(updateTime) < 0;
    }

    public boolean entryExists(Object key) {
        return this.cacheStore.entryExists(key);
    }
}

