/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.submitutils;

import com.adobe.aemds.guide.service.GuideException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.jcr.Node;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRequestParameter
implements RequestParameter {
    private String fileName;
    private String contentType;
    private byte[] fileBytes;
    private Logger logger = LoggerFactory.getLogger(FileRequestParameter.class);

    public FileRequestParameter(String fileName, Resource fileResource) {
        this.fileName = fileName;
        try {
            if (fileResource != null) {
                Node jcrNode = fileResource.adaptTo(Node.class);
                Node jcrContent = jcrNode.getNode("jcr:content");
                InputStream is = jcrContent.getProperty("jcr:data").getBinary().getStream();
                this.fileBytes = IOUtils.toByteArray(is);
                is.close();
                this.contentType = jcrContent.getProperty("jcr:mimeType").getString();
            }
        }
        catch (Exception e) {
            this.logger.error("Exception in getting initialising filebytes and content type : " + e.getMessage(), e);
            throw new GuideException(e);
        }
    }

    public FileRequestParameter(String fileName, byte[] fileBytes, String contentType) {
        this.fileBytes = (byte[])fileBytes.clone();
        this.fileName = fileName;
        this.contentType = contentType;
    }

    @Override
    public InputStream getInputStream() {
        ByteArrayInputStream is = null;
        try {
            if (this.fileBytes != null) {
                is = new ByteArrayInputStream(this.fileBytes);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception in getting inputstream : " + e.getMessage(), e);
            throw new GuideException(e);
        }
        return is;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isFormField() {
        return false;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] get() {
        return this.fileBytes;
    }

    @Override
    public String getString() {
        return new String(this.fileBytes);
    }

    @Override
    public String getString(String encoding) {
        String result = null;
        try {
            result = new String(this.fileBytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Exception in encoding : " + e.getMessage(), e);
            throw new GuideException(e);
        }
        return result;
    }

    @Override
    public long getSize() {
        byte[] bytes = this.get();
        return bytes.length;
    }
}

