/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.theme.model.impl;

import com.adobe.aemds.guide.themes.model.BreakpointInfo;
import com.adobe.aemds.guide.themes.model.ThemeMetadata;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={Resource.class}, adapters={ThemeMetadata.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class ThemeMetadataImpl
implements ThemeMetadata {
    private final Resource resource;
    @Inject
    private String clientlibCategory;
    @Inject
    private String clientlibRef;
    @Inject
    private String formRef;
    @Inject
    private String title;
    @Inject
    private String webFontConfigRef;
    @Inject
    List<BreakpointInfo> breakpoints;
    @Inject
    private Boolean hasCustomThumbnail;
    @Inject
    @Named(value="fd:version")
    @Default(values={"1.0"})
    private String themeVersion;
    @Inject
    @Named(value="fd:targetVersion")
    @Default(values={"1.0"})
    private String compatibilityVersion;

    public ThemeMetadataImpl(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getClientlibCategory() {
        return this.clientlibCategory;
    }

    @Override
    public String getClientlibRef() {
        return this.clientlibRef;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getTitle() {
        if (StringUtils.isNotBlank(this.title)) {
            return this.title;
        }
        return this.resource.getParent().getParent().getName();
    }

    @Override
    public String getWebFontConfigRef() {
        return this.webFontConfigRef;
    }

    @Override
    public String getThemeVersion() {
        return this.themeVersion;
    }

    @Override
    public String getCompatibilityVersion() {
        return this.compatibilityVersion;
    }

    @Override
    public String getFormRef() {
        if (this.formRef != null) {
            return this.formRef;
        }
        return this.resource.getResourceResolver().getResource("fd/af/themes/default").getPath();
    }

    @Override
    public String getFormPagePath() {
        ResourceResolver resolver = this.resource.getResourceResolver();
        String formRef = this.getFormRef();
        if (formRef != null) {
            String path = null;
            String documentType = (String)resolver.getResource(formRef).getChild("jcr:content").getValueMap().get("type");
            path = StringUtils.equals(documentType, "mcdocument") ? GuideUtils.convertADAssetPathToWebChannelPagePath(formRef) : GuideUtils.convertFMAssetPathToFormPagePath(formRef);
            if (resolver.getResource(path) != null) {
                return path;
            }
        }
        return resolver.getResource("fd/af/themes/default").getPath();
    }

    @Override
    public List<BreakpointInfo> getBreakpoints() {
        return this.breakpoints;
    }

    @Override
    public Boolean getHasCustomThumbnail() {
        return this.hasCustomThumbnail;
    }
}

