/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.themes;

import com.adobe.aemds.guide.utils.GuideThemeUtils;
import java.util.ArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="sling.post.operation", value={"af:copyStyleOperation"})
public class CopyStylePostOperation
implements PostOperation {
    private Logger log = LoggerFactory.getLogger(CopyStylePostOperation.class);

    @Override
    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        try {
            Resource toResource = request.getResource();
            ResourceResolver resourceResolver = request.getResourceResolver();
            String fromResourcePath = request.getParameter("fromEditablePath");
            Resource fromResource = resourceResolver.getResource(fromResourcePath);
            String fromResourceStylePath = fromResourcePath + "/" + "style";
            Resource fromResourceStyle = resourceResolver.getResource(fromResourceStylePath);
            String cssClass = request.getParameter("cssClass");
            if (toResource != null && fromResource != null) {
                GuideThemeUtils.copyAssets(fromResource, toResource, resourceResolver);
                GuideThemeUtils.copyStyles(fromResource, toResource, resourceResolver, cssClass);
            }
            if (fromResourceStyle != null && processors != null) {
                for (SlingPostProcessor processor : processors) {
                    ArrayList<Modification> changes = new ArrayList<Modification>();
                    processor.process(request, changes);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error in copyStyleAsset postOperation", e);
        }
    }
}

