/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.themes;

import com.adobe.aemds.guide.service.GuideException;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;

@Component(metatype=false)
@Service
@Property(name="sling.post.operation", value={"af:saveStyleOperation"})
public class SaveThemePostOperation
implements PostOperation {
    @Reference(target="(sling.post.operation=import)")
    private PostOperation importOperation;
    @Reference(target="(sling.post.operation=delete)")
    private PostOperation deleteOperation;

    @Override
    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        Boolean isTheme = this.isTheme(request);
        if (request.getParameter(":content") == null) {
            if (!isTheme.booleanValue()) {
                Resource resource = request.getResource();
                if (resource != null) {
                    ResourceResolver rr = request.getResourceResolver();
                    ModifiableValueMap map = resource.adaptTo(ModifiableValueMap.class);
                    if (map != null) {
                        if (map.containsKey("cssStyle")) {
                            map.remove("cssStyle");
                        }
                        if (map.containsKey("cq:cssClass")) {
                            map.remove("cq:cssClass");
                        }
                    }
                    Resource styleResource = resource.getChild("style");
                    try {
                        if (styleResource != null) {
                            rr.delete(styleResource);
                        }
                        rr.commit();
                    }
                    catch (PersistenceException e) {
                        throw new GuideException(e);
                    }
                }
            } else {
                this.deleteOperation.run(request, response, processors);
            }
        } else {
            ModifiableValueMap map;
            if (isTheme.booleanValue() && (map = request.getResource().adaptTo(ModifiableValueMap.class)) != null) {
                Set keySet = request.getResource().adaptTo(ValueMap.class).keySet();
                for (String key : request.getResource().adaptTo(ValueMap.class).keySet()) {
                    if (!key.contains("#") || key.startsWith("jcr:")) continue;
                    map.remove(key);
                }
            }
            this.importOperation.run(request, response, processors);
        }
    }

    public Boolean isTheme(SlingHttpServletRequest request) {
        if (request.getParameter("themePath") == null) {
            return false;
        }
        return true;
    }

    protected void bindImportOperation(PostOperation postOperation) {
        this.importOperation = postOperation;
    }

    protected void unbindImportOperation(PostOperation postOperation) {
        if (this.importOperation == postOperation) {
            this.importOperation = null;
        }
    }

    protected void bindDeleteOperation(PostOperation postOperation) {
        this.deleteOperation = postOperation;
    }

    protected void unbindDeleteOperation(PostOperation postOperation) {
        if (this.deleteOperation == postOperation) {
            this.deleteOperation = null;
        }
    }
}

