/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.transformer.impl;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.service.GuideSchemaType;
import com.adobe.aemds.guide.transformer.impl.ExpressionEditorResourcePropertyTransformer;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class AdaptiveFormResourcePropertyTransformer
extends ExpressionEditorResourcePropertyTransformer {
    private Map<String, Integer> elementSOMMap = new HashMap<String, Integer>();

    @Override
    public JSONObject transform(Resource resource, String parentSOM) throws JSONException {
        ValueMap props = resource.adaptTo(ValueMap.class);
        if ("layout".equals(resource.getName()) || "guideCompositeFieldItem".equals(props.get("guideNodeClass"))) {
            return null;
        }
        JSONObject obj = new JSONObject();
        if (!"items".equals(resource.getName())) {
            String name = props.get("name", null);
            String type = props.get("sling:resourceType", null);
            String nodeClass = (String)props.get("guideNodeClass");
            String typeDescriptor = this.getType(nodeClass);
            String fragRef = (String)props.get("fragRef");
            if (fragRef != null) {
                type = "FRAGMENT";
            }
            if (name == null) {
                name = resource.getName();
            }
            if ("fd/af/components/guideContainer".equals(type) || "fd/af/components/guideContainerWrapper".equals(type)) {
                name = "Form Container";
                parentSOM = "guide[0].guide1";
                GuideContainer guideContainerBean = GuideContainer.from(resource);
                GuideSchemaType schemaType = guideContainerBean.getSchema();
                String schemaRef = guideContainerBean.getSchemaRef();
                if (GuideSchemaType.XDP.equals((Object)schemaType)) {
                    obj.put("xdpRef", schemaRef);
                }
                obj.put("dorType", props.get("dorType", ""));
                obj.put("enableAdobeSign", props.get("_useSignedPdf", ""));
            } else if ("fd/adaddon/components/guideDocumentContainer".equals(type) || "fd/ccm/web-channel/components/documentContainer/v1/documentContainer".equals(type)) {
                name = "Document Container";
                parentSOM = "guide[0].guide1";
            }
            String id = name;
            if (!StringUtils.equals("signerInfo", id) && !StringUtils.equals("signerInfo", parentSOM)) {
                String htmlVal;
                JSONArray adobeSignFields;
                if (parentSOM.length() > 0) {
                    Integer somCounter;
                    if (!StringUtils.equals("Form Container", name) && !StringUtils.equals("Document Container", name)) {
                        parentSOM = parentSOM + "." + name;
                    }
                    int counter = (somCounter = this.elementSOMMap.get(parentSOM)) == null ? 0 : somCounter;
                    this.elementSOMMap.put(parentSOM, counter + 1);
                    parentSOM = parentSOM + "[" + counter + "]";
                }
                obj.put("id", id);
                obj.put("SOM", parentSOM);
                obj.put("fragRef", fragRef);
                obj.put("name", name);
                obj.put("type", type);
                obj.put("typeDescriptor", typeDescriptor);
                obj.put("displayName", props.get("jcr:title"));
                obj.put("path", resource.getPath());
                if (GuideUtils.isStaticTextType(nodeClass) && props.containsKey("_value") && (adobeSignFields = GuideUtils.getAdobeSignFields(htmlVal = (String)props.get("_value"))) != null && adobeSignFields.length() > 0) {
                    obj.put("adobeSignFields", adobeSignFields);
                }
            } else {
                obj.put("SOM", "signerInfo");
                for (Map.Entry entry : props.entrySet()) {
                    obj.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
        return obj;
    }
}

