/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.transformer.impl;

import com.adobe.aemds.guide.transformer.api.ResourcePropertyTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionEditorResourcePropertyTransformer
implements ResourcePropertyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionEditorResourcePropertyTransformer.class);
    private static final Map<String, String> nodeClassToTypeMap = new HashMap<String, String>();
    private static final String STATUS_NONE = "none";
    private static final String STATUS_VALID = "valid";
    private static final String STATUS_INVALID = "invalid";
    private static final String[] expressionTypes;
    private Map<String, Integer> elementSOMMap = new HashMap<String, Integer>();

    public String getType(String guideNodeClass) {
        String result = nodeClassToTypeMap.get(guideNodeClass);
        if (result == null) {
            result = guideNodeClass;
        }
        return result;
    }

    @Override
    public JSONObject transform(Resource resource, String parentSOM) throws JSONException {
        ValueMap props = resource.adaptTo(ValueMap.class);
        JSONObject obj = new JSONObject();
        if (!"items".equals(resource.getName())) {
            int index;
            String name = (String)props.get("name");
            String nodeClass = (String)props.get("guideNodeClass");
            if (StringUtils.isEmpty(nodeClass)) {
                return null;
            }
            String type = this.getType(nodeClass);
            if (type == null) {
                return null;
            }
            if (props.containsKey("completionExpReq") && ((Boolean)((Object)props.get("completionExpReq", Boolean.class))).booleanValue()) {
                type = type + "|NAVIGABLE_PANEL";
            }
            if (props.containsKey("summaryExpVisible") && "yes".equals(props.get("summaryExpVisible", String.class))) {
                type = type + "|REPEATABLE_PANEL";
            }
            if ("FORM".equals(type)) {
                name = "FORM";
            }
            if ((index = parentSOM.lastIndexOf(46)) >= 0 && "toolbar".equals(parentSOM.substring(index + 1)) && "guideButton".equals(nodeClass)) {
                type = type + "|TOOLBAR_BUTTON";
            }
            String id = name;
            if ("FORM".equals(type)) {
                id = "guide";
            }
            if (parentSOM.length() > 0) {
                String key = id = parentSOM + "." + name;
                Integer somCounter = this.elementSOMMap.get(key);
                int counter = 0;
                if (somCounter != null) {
                    counter = somCounter;
                    id = id + "[" + counter + "]";
                }
                this.elementSOMMap.put(key, counter + 1);
            }
            obj.put("id", id);
            obj.put("SOM", id);
            obj.put("name", name);
            obj.put("type", type);
            obj.put("status", this.getStatus(resource));
            obj.put("displayName", props.get("jcr:title"));
            if ("guideRadioButton".equals(nodeClass) || "guideCheckBox".equals(nodeClass) || "guideSwitch".equals(nodeClass) || "guideDropDownList".equals(nodeClass)) {
                obj.put("options", this.getOptions(props));
            }
            obj.put("path", resource.getPath());
            obj.put("resourceType", props.get("sling:resourceType"));
            String fragRef = (String)props.get("fragRef");
            obj.put("isFragment", StringUtils.isNotEmpty(fragRef));
        }
        return obj;
    }

    private JSONObject getOptions(ValueMap props) throws JSONException {
        Object options = props.get("options");
        if (options != null && options instanceof String[]) {
            String[] optionStrings = (String[])options;
            JSONObject jsonObject = new JSONObject();
            for (String optionString : optionStrings) {
                String value;
                if (!StringUtils.isNotBlank(optionString)) continue;
                String[] parts = optionString.split("=");
                String label = value = parts[0];
                if (parts.length > 1) {
                    label = parts[1];
                }
                jsonObject.put(value, label);
            }
            return jsonObject;
        }
        return null;
    }

    private boolean isValidRule(JSONObject rule) throws JSONException {
        return !rule.has("isValid") || rule.getBoolean("isValid");
    }

    private boolean hasValidRule(JSONObject[] rules) throws JSONException {
        for (JSONObject rule : rules) {
            if (!this.isValidRule(rule)) continue;
            return true;
        }
        return false;
    }

    private JSONObject[] getRules(Resource ruleResource) throws JSONException {
        JSONObject[] retValue = new JSONObject[]{};
        if (ruleResource == null) {
            return retValue;
        }
        ValueMap props = ruleResource.adaptTo(ValueMap.class);
        if (props == null) {
            return retValue;
        }
        for (String key : props.keySet()) {
            if ("jcr:primaryType".equals(key)) continue;
            String[] rulesString = props.get(key, new String[0]);
            ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
            for (String ruleString : rulesString) {
                jsonObjectList.add(new JSONObject(ruleString));
            }
            retValue = jsonObjectList.toArray(new JSONObject[0]);
        }
        return retValue;
    }

    private String getStatusFromRules(Resource rulesResource, Resource scriptsResource) throws JSONException {
        String status = STATUS_NONE;
        JSONObject[] rules = this.getRules(rulesResource);
        JSONObject[] scripts = this.getRules(scriptsResource);
        if (rules.length > 0 || scripts.length > 0) {
            status = this.hasValidRule(rules) || this.hasValidRule(scripts) ? STATUS_VALID : STATUS_INVALID;
        }
        return status;
    }

    private String getStatusFromExpJson(String jsonString) throws JSONException {
        String status = STATUS_NONE;
        try {
            JSONObject expJson = new JSONObject(jsonString);
            JSONArray rules = (JSONArray)expJson.get("items");
            if (rules.length() > 0) {
                boolean isValid = true;
                for (int i = 0; i < rules.length() && isValid; ++i) {
                    JSONObject rule = (JSONObject)rules.get(i);
                    isValid = rule.has("isValid") ? rule.getBoolean("isValid") : true;
                }
                status = isValid ? STATUS_VALID : STATUS_INVALID;
            }
        }
        catch (JSONException e) {
            logger.error("Error while parsing expJson", e);
        }
        return status;
    }

    private String getStatus(Resource resource) throws JSONException {
        String status = STATUS_NONE;
        ValueMap props = resource.adaptTo(ValueMap.class);
        Resource rulesResource = resource.getChild("fd:rules");
        Resource scriptsResource = resource.getChild("fd:scripts");
        if (rulesResource != null || scriptsResource != null) {
            status = this.getStatusFromRules(rulesResource, scriptsResource);
        } else if (props.containsKey("expJson")) {
            status = this.getStatusFromExpJson((String)props.get("expJson"));
        } else {
            for (String script : expressionTypes) {
                if (!props.containsKey(script)) continue;
                status = STATUS_VALID;
                break;
            }
        }
        return status;
    }

    static {
        nodeClassToTypeMap.put("rootPanelNode", "ROOTPANEL|PANEL|AFCOMPONENT");
        nodeClassToTypeMap.put("guidePanel", "PANEL|AFCOMPONENT");
        nodeClassToTypeMap.put("guideCompositeFieldItem", "COMPOSITE FIELD ITEM|FIELD|AFCOMPONENT");
        nodeClassToTypeMap.put("guideRadioButton", "RADIO BUTTON|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideDropDownList", "DROPDOWN|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideChart", "CHART|AFCOMPONENT");
        nodeClassToTypeMap.put("guideCheckBox", "CHECK BOX|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideSwitch", "SWITCH|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideFileUpload", "FILE ATTACHMENT|FIELD|AFCOMPONENT|BINARY");
        nodeClassToTypeMap.put("guideTextBox", "TEXT FIELD|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideTelephone", "TELEPHONE|FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideButton", "BUTTON|AFCOMPONENT");
        nodeClassToTypeMap.put("guideContainerNode", "FORM");
        nodeClassToTypeMap.put("guideDatePicker", "DATE FIELD|FIELD|AFCOMPONENT|DATE");
        nodeClassToTypeMap.put("guideImage", "IMAGE|AFCOMPONENT");
        nodeClassToTypeMap.put("guideNumericBox", "NUMBER FIELD|FIELD|AFCOMPONENT|NUMBER");
        nodeClassToTypeMap.put("guidePasswordBox", "PASSWORD FIELD|AFCOMPONENT|STRING");
        nodeClassToTypeMap.put("guideScribble", "SCRIBBLE FIELD|FIELD|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTermsAndConditions", "TERMS AND CONDITIONS|FIELD|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTextDraw", "STATIC TEXT|AFCOMPONENT");
        nodeClassToTypeMap.put("guideAdobeSignBlock", "STATIC TEXT|AFCOMPONENT");
        nodeClassToTypeMap.put("guideAdModule", "STATIC TEXT|AFCOMPONENT");
        nodeClassToTypeMap.put("guideAdModuleGroup", "PANEL|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTable", "TABLE|AFCOMPONENT");
        nodeClassToTypeMap.put("guideTableRow", "TABLE ROW|AFCOMPONENT");
        expressionTypes = new String[]{"clickExp", "navigationChangeExp", "visibleExp", "initScript", "calcExp", "valueCommitScript", "validateExp", "completionExp", "summaryExp", "optionsExp", "enabledExp"};
    }
}

