/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideFragmentHolder;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.script.SimpleBindings;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, immediate=true, label="NodeStructureUtils")
@Service(value={NodeStructureUtils.class})
public class NodeStructureUtils {
    private static final Logger log = LoggerFactory.getLogger(NodeStructureUtils.class.getName());
    public static final String GUIDECONTAINER_NODENAME = "guideContainer";
    public static final String GUIDE_FRAG_ROOT_PANEL = "rootPanel";
    public static final String LAYOUT_NODENAME = "layout";
    public static final String ROOTPANEL_NODENAME = "rootPanel";
    public static final String ROOTPANEL_NODECLASS = "rootPanelNode";
    public static final String PANEL_NODENAME = "panel";
    public static final String GUIDE_ITEMS = "items";
    public static final String DEFAULT_LAYOUT_GUIDECONTAINER = "defaultGuideLayout";
    public static final String DEFAULT_LAYOUT_ROOTPANEL = "panel/tabbedPanelLayout";
    public static final String DEFAULT_LAYOUT_PANEL = "gridFluidLayout2";
    public static String RT_GUIDES_PREFIX = "/libs/fd/af/components/";
    public static String RT_GUIDES_LAYOUT_PREFIX = "/libs/fd/af/layouts/";
    public static final String RT_GUIDES_ROOTPANEL = RT_GUIDES_PREFIX + "rootPanel";
    public static final String RT_GUIDES_LAYOUT_GUIDECONTAINER = RT_GUIDES_LAYOUT_PREFIX + "defaultGuideLayout";
    public static final String RT_GUIDES_LAYOUT_ROOTPANEL = RT_GUIDES_LAYOUT_PREFIX + "panel/tabbedPanelLayout";
    public static final String RT_GUIDES_LAYOUT_PANEL = RT_GUIDES_LAYOUT_PREFIX + "gridFluidLayout2";
    public static final String LAYOUT_PATH_PROPERTY = "sling:resourceType";
    public static final String ELEMENT_PROPERTY_NAME = "name";
    private static final String ELEMENT_PROPERTY_DESCRIPTION = "jcr:description";
    private static final String ELEMENT_PROPERTY_QTIP = "qtip";
    private static final String ELEMENT_PROPERTY_TITLE = "jcr:title";
    private static final String ELEMENT_PROPERTY_IMAGE = "imagePath";
    public static final String FRAG_REF = "fragRef";
    @Deprecated
    public static final String RT_PARSYS = "/libs/foundation/components/parsys";
    private static NodeStructureUtils nodeStructureUtils = null;
    private static Map<String, String> layoutmap;

    public NodeStructureUtils() {
        layoutmap = new HashMap<String, String>();
        layoutmap.put(GUIDECONTAINER_NODENAME, RT_GUIDES_LAYOUT_GUIDECONTAINER);
        layoutmap.put("rootPanel", RT_GUIDES_LAYOUT_ROOTPANEL);
        layoutmap.put(PANEL_NODENAME, RT_GUIDES_LAYOUT_PANEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeStructureUtils getInstance() {
        if (nodeStructureUtils != null) return nodeStructureUtils;
        Class<NodeStructureUtils> clazz = NodeStructureUtils.class;
        synchronized (NodeStructureUtils.class) {
            if (nodeStructureUtils != null) return nodeStructureUtils;
            nodeStructureUtils = new NodeStructureUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return nodeStructureUtils;
        }
    }

    private static boolean checkName(Resource resource, String name) {
        return resource.getName().equals(name);
    }

    public static Map<String, Object> getLayoutProperties(SlingHttpServletRequest request, Resource elementResource, String cmpName) throws PersistenceException {
        if (elementResource == null) {
            return null;
        }
        Resource layoutnode = null;
        ResourceResolver resourceResolver = null;
        if (request != null) {
            resourceResolver = request.getResourceResolver();
        }
        Iterator<Resource> iter = null;
        if (cmpName == null) {
            Resource parentRes = elementResource.getParent();
            iter = elementResource.getParent().listChildren();
        } else {
            iter = elementResource.listChildren();
        }
        while (iter.hasNext() && layoutnode == null) {
            Resource current = iter.next();
            if (!NodeStructureUtils.checkName(current, LAYOUT_NODENAME)) continue;
            layoutnode = current;
        }
        if (layoutnode == null) {
            if (resourceResolver == null) {
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                String resourceType = layoutmap.get(cmpName);
                map.put(LAYOUT_PATH_PROPERTY, resourceType);
                String nodeName = LAYOUT_NODENAME;
                resourceResolver.create(elementResource, LAYOUT_NODENAME, map);
            }
            catch (PersistenceException re) {
                log.error("Unable to create missing layout element for guide node " + elementResource, re);
                throw new GuideException(re);
            }
            finally {
                if (resourceResolver.hasChanges()) {
                    resourceResolver.refresh();
                }
            }
            return map;
        }
        return ResourceUtil.getValueMap(layoutnode);
    }

    public static void setGuideName(Resource rsrc, String name) throws GuideException {
        block5: {
            Session currentSession = rsrc.getResourceResolver().adaptTo(Session.class);
            try {
                if (currentSession.hasPermission(rsrc.getPath(), "set_property")) {
                    ModifiableValueMap modifiableMap = rsrc.adaptTo(ModifiableValueMap.class);
                    modifiableMap.put(ELEMENT_PROPERTY_NAME, name);
                    try {
                        rsrc.getResourceResolver().commit();
                        break block5;
                    }
                    catch (PersistenceException e) {
                        log.error("unable to set name property on " + rsrc.getPath(), e);
                        throw new GuideException(e);
                    }
                }
                log.error("user has no write permission on the node " + rsrc.getPath() + ". Adaptive Form will not work properly");
            }
            catch (RepositoryException e) {
                log.error("unable to check the permissions for setting property on " + rsrc.getPath(), e);
                throw new GuideException(e);
            }
        }
    }

    public static String getGuideName(Resource rsrc) throws GuideException {
        ValueMap properties = ResourceUtil.getValueMap(rsrc);
        String name = properties.get(ELEMENT_PROPERTY_NAME, "");
        if (name == null || name.isEmpty()) {
            String resourceName = GuideUtils.removePrefix(rsrc.getName(), "guide") + Calendar.getInstance().getTimeInMillis();
            NodeStructureUtils.setGuideName(rsrc, resourceName);
            name = rsrc.getName();
        }
        return name;
    }

    public static String getLayoutDescription(Resource rsrc) {
        ValueMap properties = ResourceUtil.getValueMap(rsrc);
        String desc = properties.get(ELEMENT_PROPERTY_DESCRIPTION, "");
        if (desc.length() == 0) {
            desc = properties.get(ELEMENT_PROPERTY_TITLE, "");
        }
        return desc;
    }

    public static String getLayoutQtip(Resource rsrc) {
        ValueMap properties = ResourceUtil.getValueMap(rsrc);
        String qtip = properties.get(ELEMENT_PROPERTY_QTIP, "");
        return qtip;
    }

    public static String getGuideNavigatorTabProperty(Resource rsrc) {
        ValueMap properties = ResourceUtil.getValueMap(rsrc);
        String guideNavigatorTab = properties.get("guideNavigatorTab", "");
        return guideNavigatorTab;
    }

    public static String getFragPrefixString(Resource fragRefNode, String previousPrefixId) {
        String fragPrefix = null;
        try {
            String pathAfterRootPanel = StringUtils.substringAfter(fragRefNode.getPath(), "/rootPanel/items/");
            if (StringUtils.isNotEmpty(previousPrefixId)) {
                fragPrefix = previousPrefixId + pathAfterRootPanel + "/";
            } else {
                fragPrefix = NodeStructureUtils.generateIdForGuideNodes(fragRefNode.getPath(), fragRefNode);
                fragPrefix = fragPrefix + "/items/";
            }
        }
        catch (Exception e) {
            log.error("Error while getting fragRef prefix string", e);
        }
        return fragPrefix;
    }

    public static String getGuideNodeHtmlId(Resource elementResource) {
        return NodeStructureUtils.getGuideNodeHtmlId(elementResource, null);
    }

    public static String getGuideNodeHtmlId(Resource elementResource, String fragPrefixId) {
        String path = elementResource.getPath();
        if (!path.contains("/guideContainer")) {
            log.debug("getGuideNodeHtmlId-path does not have guideContainer:" + path);
            return path;
        }
        String nodeHtmlId = null;
        String fragPrefixidString = null;
        if (fragPrefixId == null) {
            GuideFragmentHolder guideFragmentHolder = null;
            try {
                guideFragmentHolder = GuideContainerThreadLocal.getGuideFragmentHolder();
                if (guideFragmentHolder != null) {
                    fragPrefixidString = guideFragmentHolder.getFragPrefixID();
                }
            }
            catch (Exception e) {
                log.error("Error while getting thread local from NodeStructureUtils", e);
            }
        } else {
            fragPrefixidString = fragPrefixId;
        }
        nodeHtmlId = fragPrefixidString != null && fragPrefixidString.length() > 0 ? NodeStructureUtils.generateIdForFragmentNodes(path, fragPrefixidString) : NodeStructureUtils.generateIdForGuideNodes(path, elementResource);
        return NodeStructureUtils.manipulateNodeHtmlId(nodeHtmlId);
    }

    private static String getContainerNodeName(Resource elementResource) {
        Resource parent;
        String containerName = GuideContainerThreadLocal.getGuideContainerName();
        if (containerName != null) {
            return containerName;
        }
        log.debug("Guide container name not found in ThreadLocal.");
        if (GuideUtils.isGuideContainerResource(elementResource)) {
            log.debug("Container name retrieved from node structure: " + elementResource.getName());
            return elementResource.getName();
        }
        for (parent = elementResource.getParent(); parent != null && !GuideUtils.isGuideContainerResource(parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            String parentName = parent.getName();
            log.debug("Container name retrieved from node structure: " + parentName);
            return parentName;
        }
        return "";
    }

    private static String generateIdForGuideNodes(String path, Resource elementResource) {
        String nodeHtmlId = null;
        String containerName = GUIDECONTAINER_NODENAME;
        if (elementResource != null) {
            containerName = NodeStructureUtils.getContainerNodeName(elementResource);
        }
        nodeHtmlId = elementResource != null && GuideUtils.isGuideContainerResource(elementResource) ? containerName : containerName + "-" + StringUtils.substringAfter(path, "/" + containerName + "/");
        return nodeHtmlId;
    }

    private static String generateIdForFragmentNodes(String path, String fragPrefix) {
        return fragPrefix + StringUtils.substringAfter(path, "/rootPanel/items/");
    }

    private static String manipulateNodeHtmlId(String nodeHtmlId) {
        return nodeHtmlId.replaceAll("/items/", "-").replaceAll("/", "-").replaceAll("\\.", "-") + "__";
    }

    public static Map<String, Object> getLayoutProperties(Resource elementResource, SlingHttpServletRequest request) throws PersistenceException {
        return NodeStructureUtils.getLayoutProperties(request, elementResource, null);
    }

    public static Map<String, Object> getLayoutProperties(Resource elementResource) throws PersistenceException {
        return NodeStructureUtils.getLayoutProperties(null, elementResource, null);
    }

    public static Map<String, Object> getRootPanel(SlingHttpServletRequest request, Resource elementResource) throws RepositoryException {
        if (elementResource == null) {
            return null;
        }
        Iterator<Resource> iter = elementResource.listChildren();
        Resource rootpanel = null;
        ResourceResolver resourceResolver = request.getResourceResolver();
        while (iter.hasNext() && rootpanel == null) {
            Resource current = iter.next();
            if (!NodeStructureUtils.checkName(current, "rootPanel")) continue;
            rootpanel = current;
        }
        if (rootpanel == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String css = "rootPanel";
            try {
                String resourceType = RT_GUIDES_ROOTPANEL;
                map.put(LAYOUT_PATH_PROPERTY, resourceType);
                map.put("guideNodeClass", ROOTPANEL_NODECLASS);
                map.put(ELEMENT_PROPERTY_NAME, "rootPanel");
                String nodeName = "rootPanel";
                resourceResolver.create(elementResource, "rootPanel", map);
            }
            catch (PersistenceException re) {
                log.error("Unable to create missing root panel element for guide node " + elementResource, re);
                throw new GuideException(re);
            }
            finally {
                if (resourceResolver.hasChanges()) {
                    resourceResolver.refresh();
                }
            }
            return map;
        }
        return ResourceUtil.getValueMap(rootpanel);
    }

    public static List getItems(SlingHttpServletRequest request, Resource elementResource) throws RepositoryException {
        Resource current;
        Iterator<Resource> iter = elementResource.listChildren();
        ResourceResolver resourceResolver = request.getResourceResolver();
        Resource items = elementResource;
        ArrayList<GuideNode> result = new ArrayList<GuideNode>();
        while (iter.hasNext() && items == null) {
            current = iter.next();
            if (!NodeStructureUtils.checkName(current, GUIDE_ITEMS)) continue;
            items = current;
        }
        if (items == null) {
            if (elementResource != null) {
                try {
                    String nodeName = GUIDE_ITEMS;
                    resourceResolver.create(elementResource, GUIDE_ITEMS, null);
                }
                catch (PersistenceException re) {
                    log.error("Unable to create missing layout element for guide node " + elementResource, re);
                    throw new GuideException(re);
                }
                finally {
                    if (resourceResolver.hasChanges()) {
                        resourceResolver.refresh();
                    }
                }
            }
        } else {
            iter = items.listChildren();
            try {
                while (iter.hasNext()) {
                    current = iter.next();
                    GuideNode newNode = new GuideNode();
                    SimpleBindings bindings = new SimpleBindings();
                    bindings.put("resource", (Object)current);
                    bindings.put("request", (Object)request);
                    newNode.init(bindings);
                    result.add(newNode);
                }
            }
            catch (Exception ex) {
                log.error("unable to iterate items for the resource " + elementResource.getPath(), ex);
                throw new GuideException(ex);
            }
        }
        return result;
    }

    public static void createProperty(Resource elementResource, String propName, String propValue, Boolean override) {
        Node node = elementResource.adaptTo(Node.class);
        if (node != null) {
            try {
                if (override.booleanValue() || !node.hasProperty(propName)) {
                    node.setProperty(propName, propValue);
                }
                node.getSession().save();
            }
            catch (RepositoryException re) {
                log.error("Unable to set property for the guide node " + elementResource + " propName :" + propName, re);
                throw new GuideException(re);
            }
            finally {
                try {
                    if (node.getSession().hasPendingChanges()) {
                        node.getSession().refresh(false);
                    }
                }
                catch (RepositoryException re) {
                    log.trace("Error in create property: ignoring it." + re.getMessage(), re);
                }
            }
        }
    }
}

