/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.api;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.PaymentMethod;
import com.adobe.cq.commerce.api.PlacedOrder;
import com.adobe.cq.commerce.api.PlacedOrderResult;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.ShippingMethod;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.api.promotion.VoucherInfo;
import com.adobe.cq.commerce.api.smartlist.SmartListManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Predicate;

@ConsumerType
public interface CommerceSession {
    public static final String PN_QUANTITY = "quantity";
    public static final String PN_READONLY = "readonly";

    public void logout() throws CommerceException;

    public void setUserLocale(Locale var1);

    public Locale getUserLocale();

    public List<String> getAvailableCountries() throws CommerceException;

    public List<ShippingMethod> getAvailableShippingMethods() throws CommerceException;

    public List<PaymentMethod> getAvailablePaymentMethods() throws CommerceException;

    public List<PriceInfo> getProductPriceInfo(Product var1) throws CommerceException;

    public List<PriceInfo> getProductPriceInfo(Product var1, Predicate var2) throws CommerceException;

    public String getProductPrice(Product var1, Predicate var2) throws CommerceException;

    public String getProductPrice(Product var1) throws CommerceException;

    public int getCartEntryCount() throws CommerceException;

    public List<CartEntry> getCartEntries() throws CommerceException;

    public List<PriceInfo> getCartPriceInfo(Predicate var1) throws CommerceException;

    public String getCartPrice(Predicate var1) throws CommerceException;

    public void addCartEntry(Product var1, int var2) throws CommerceException;

    public void addCartEntry(Product var1, int var2, Map<String, Object> var3) throws CommerceException;

    public void modifyCartEntry(int var1, int var2) throws CommerceException;

    public void modifyCartEntry(int var1, Map<String, Object> var2) throws CommerceException;

    public void deleteCartEntry(int var1) throws CommerceException;

    public void addVoucher(String var1) throws CommerceException;

    public void removeVoucher(String var1) throws CommerceException;

    public List<VoucherInfo> getVoucherInfos() throws CommerceException;

    public boolean supportsClientsidePromotionResolution();

    public void addPromotion(String var1) throws CommerceException;

    public void removePromotion(String var1) throws CommerceException;

    public List<PromotionInfo> getPromotions() throws CommerceException;

    public String getOrderId() throws CommerceException;

    public Map<String, Object> getOrderDetails(String var1) throws CommerceException;

    public Map<String, Object> getOrder() throws CommerceException;

    public void updateOrderDetails(Map<String, Object> var1, String var2) throws CommerceException;

    public void updateOrder(Map<String, Object> var1) throws CommerceException;

    public void placeOrder(Map<String, Object> var1) throws CommerceException;

    public PlacedOrderResult getPlacedOrders(String var1, int var2, int var3, String var4) throws CommerceException;

    public PlacedOrder getPlacedOrder(String var1) throws CommerceException;

    public SmartListManager getSmartListManager();

    @Deprecated
    public String getPriceInfo(Product var1) throws CommerceException;

    @Deprecated
    public String getCartPreTaxPrice() throws CommerceException;

    @Deprecated
    public String getCartTax() throws CommerceException;

    @Deprecated
    public String getCartTotalPrice() throws CommerceException;

    @Deprecated
    public String getOrderShipping() throws CommerceException;

    @Deprecated
    public String getOrderTotalTax() throws CommerceException;

    @Deprecated
    public String getOrderTotalPrice() throws CommerceException;

    @Deprecated
    public List<Voucher> getVouchers() throws CommerceException;

    @Deprecated
    public void updateOrderDetails(Map<String, String> var1) throws CommerceException;

    @Deprecated
    public Map<String, String> getOrderDetails() throws CommerceException;

    @Deprecated
    public void submitOrder(Map<String, String> var1) throws CommerceException;

    public static interface CartEntry {
        public int getEntryIndex();

        public Product getProduct() throws CommerceException;

        public int getQuantity();

        public List<PriceInfo> getPriceInfo(Predicate var1) throws CommerceException;

        public String getPrice(Predicate var1) throws CommerceException;

        public <T> T getProperty(String var1, Class<T> var2);

        @Deprecated
        public String getUnitPrice();

        @Deprecated
        public String getPreTaxPrice();

        @Deprecated
        public String getTax();

        @Deprecated
        public String getTotalPrice();
    }
}

