/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.screens.impl.aemio;

import com.adobe.cq.screens.device.Device;
import com.adobe.cq.screens.device.DeviceManager;
import com.adobe.cq.screens.impl.aemio.ScreensModelLookup;
import com.adobe.granite.haf.annotations.ApiEntities;
import com.adobe.granite.haf.annotations.ApiModel;
import com.adobe.granite.haf.annotations.ApiProperty;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class})
@ApiModel(category="screens", type={"aem-io/screens/devicesfolder"}, modelLookup=ScreensModelLookup.class)
public class ScreensDevicesFolderModel {
    @Inject
    @Self
    protected Resource baseResource;
    @Inject
    @Named(value="jcr:content")
    protected Resource jcrContent;

    @ApiProperty
    public String getTitle() {
        return (String)((Object)ResourceUtil.getValueMap(this.jcrContent).get("jcr:title", String.class));
    }

    @ApiProperty
    public String getDescription() {
        return (String)((Object)ResourceUtil.getValueMap(this.jcrContent).get("jcr:description", String.class));
    }

    @ApiEntities
    public Iterable<Resource> children() {
        ArrayList<Resource> results = new ArrayList<Resource>();
        String tenant = this.baseResource.getPath().split("/")[3];
        DeviceManager dm = this.baseResource.getResourceResolver().adaptTo(DeviceManager.class);
        if (dm != null) {
            Iterator<Device> devices = dm.getDevices(new DevicesPredicate(tenant));
            while (devices.hasNext()) {
                results.add(devices.next().adaptTo(Resource.class));
            }
        }
        return results;
    }

    private static class DevicesPredicate
    implements Predicate {
        private final String prefix;

        private DevicesPredicate(@Nonnull String tenant) {
            this.prefix = "/home/users/screens/" + tenant + "/devices";
        }

        @Override
        public boolean evaluate(Object d) {
            return ((Device)d).getPath().startsWith(this.prefix);
        }
    }
}

