/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.JcrUtils;

public class IndexUtil {
    public static void createLucenePropertyIndex(Node root, String indexName, String propertyName, String propertyType, boolean ordered, boolean pathRestrictionsEnabled) throws RepositoryException {
        IndexUtil.createLuceneIndex(root, indexName, propertyName, propertyType, false, ordered, pathRestrictionsEnabled);
    }

    public static void createLuceneFulltextIndex(Node root, String indexName, String propertyName, boolean pathRestrictionsEnabled) throws RepositoryException {
        IndexUtil.createLuceneIndex(root, indexName, propertyName, null, true, false, pathRestrictionsEnabled);
    }

    private static void createLuceneIndex(Node root, String indexName, String propertyName, String propertyType, boolean fullText, boolean ordered, boolean pathRestrictionsEnabled) throws RepositoryException {
        Node indexRoot = JcrUtils.getOrAddNode(root, "oak:index", "nt:unstructured");
        if (!indexRoot.hasNode(indexName)) {
            Node luceneIndex = indexRoot.addNode(indexName, "oak:QueryIndexDefinition");
            luceneIndex.setProperty("type", "lucene");
            luceneIndex.setProperty("async", "async");
            luceneIndex.setProperty("compatVersion", 2L);
            luceneIndex.setProperty("evaluatePathRestrictions", pathRestrictionsEnabled);
            Node indexRules = luceneIndex.addNode("indexRules", "nt:unstructured");
            Node nodeType = indexRules.addNode("nt:base", "nt:unstructured");
            Node properties = nodeType.addNode("properties", "nt:unstructured");
            luceneIndex = properties.addNode(indexName);
            luceneIndex.setProperty("name", propertyName);
            if (fullText) {
                luceneIndex.setProperty("analyzed", true);
            } else {
                luceneIndex.setProperty("propertyIndex", true);
                if (ordered) {
                    luceneIndex.setProperty("ordered", true);
                }
            }
            if (propertyType != null) {
                luceneIndex.setProperty("type", propertyType);
            }
        }
    }
}

