/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.learningpath.endpoints.api;

import com.adobe.cq.social.enablement.learningpath.endpoints.api.EnablementLearningPathModelOperations;
import com.adobe.cq.social.enablement.learningpath.endpoints.api.EnablementLearningPathModelServiceCreate;
import com.adobe.cq.social.enablement.learningpath.endpoints.api.EnablementLearningPathModelServicePublish;
import com.adobe.cq.social.enablement.learningpath.endpoints.api.EnablementLearningPathModelServiceUpdate;
import com.adobe.cq.social.enablement.learningpath.model.api.EnablementLearningPathModel;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import java.util.Map;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
@Properties(value={@Property(name="fieldWhitelist", value={}, description="List of allowed whitelisted custom properties", cardinality=100)})
public abstract class AbstractEnablementLearningPathModelOperationService<T extends OperationExtension, U extends Operation>
extends AbstractOperationService<T, U, EnablementLearningPathModel>
implements EnablementLearningPathModelOperations {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Reference
    private EnablementLearningPathModelServiceCreate enablementLearningPathModelOperationServiceCreate;
    @Reference
    private EnablementLearningPathModelServiceUpdate enablementLearningPathModelOperationServiceUpdate;
    @Reference
    private EnablementLearningPathModelServicePublish enablementLearningPathModelOperationServicePublish;
    protected String[] fieldWhitelist;
    protected static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";

    @Activate
    protected void activate(ComponentContext context) {
        Object whitelist = context.getProperties().get(PROPERTY_FIELD_WHITELIST);
        this.fieldWhitelist = PropertiesUtil.toStringArray(whitelist);
    }

    @Override
    public SocialComponent create(SlingHttpServletRequest request) throws OperationException {
        try {
            this.LOGGER.debug("Enablement Learning Path Model Create operation.");
            Map<String, Object> properties = this.enablementLearningPathModelOperationServiceCreate.getOperationProperties(request, this.fieldWhitelist);
            U createOperation = this.getCreateOperation();
            Resource parentResource = request.getResource();
            ResourceResolver resolver = parentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(createOperation, session, parentResource, properties);
            EnablementLearningPathModel enablementLearningPathModel = this.enablementLearningPathModelOperationServiceCreate.create(request, properties, this.fieldWhitelist);
            if (enablementLearningPathModel != null) {
                this.performAfterActions(createOperation, session, enablementLearningPathModel, properties);
                return enablementLearningPathModel;
            }
        }
        catch (Exception e) {
            throw new OperationException("Internal error creating enablementLearningPathModel.", e, 500);
        }
        throw new OperationException("Unable to obtain EnablementLearningPathModel component.", 500);
    }

    @Override
    public SocialComponent update(SlingHttpServletRequest request) throws OperationException {
        try {
            this.LOGGER.debug("Enablement Learning Path Model Update operation.");
            Map<String, Object> properties = this.enablementLearningPathModelOperationServiceUpdate.getOperationProperties(request, this.fieldWhitelist);
            U reportOperation = this.getUpdateOperation();
            Resource parentResource = request.getResource();
            ResourceResolver resolver = parentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(reportOperation, session, parentResource, properties);
            EnablementLearningPathModel enablementLearningPathModel = this.enablementLearningPathModelOperationServiceUpdate.update(request, properties, this.fieldWhitelist);
            if (enablementLearningPathModel != null) {
                this.performAfterActions(reportOperation, session, enablementLearningPathModel, properties);
                return enablementLearningPathModel;
            }
        }
        catch (Exception e) {
            throw new OperationException("Internal error updating enablementLearningPathModel.", e, 500);
        }
        throw new OperationException("Unable to obtain EnablementLearningPathModel component.", 500);
    }

    @Override
    public SocialComponent publish(SlingHttpServletRequest request) throws OperationException {
        try {
            this.LOGGER.debug("Enablement Learning Path Model Report operation.");
            Map<String, Object> properties = this.enablementLearningPathModelOperationServicePublish.getOperationProperties(request, this.fieldWhitelist);
            U reportOperation = this.getPublishOperation();
            Resource parentResource = request.getResource();
            ResourceResolver resolver = parentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(reportOperation, session, parentResource, properties);
            EnablementLearningPathModel enablementLearningPathModel = this.enablementLearningPathModelOperationServicePublish.publish(request, properties);
            if (enablementLearningPathModel != null) {
                this.performAfterActions(reportOperation, session, enablementLearningPathModel, properties);
                return enablementLearningPathModel;
            }
        }
        catch (Exception e) {
            throw new OperationException("Internal error creating enablementLearningPathModel.", e, 500);
        }
        throw new OperationException("Unable to obtain EnablementLearningPathModel component.", 500);
    }

    protected String getResourceType() {
        return "social/enablement/components/hbs/model/learningpath";
    }

    protected abstract U getCreateOperation();

    protected abstract U getPublishOperation();

    protected abstract U getUpdateOperation();

    protected abstract U getReportOperation();

    protected void bindEnablementLearningPathModelOperationServiceCreate(EnablementLearningPathModelServiceCreate enablementLearningPathModelServiceCreate) {
        this.enablementLearningPathModelOperationServiceCreate = enablementLearningPathModelServiceCreate;
    }

    protected void unbindEnablementLearningPathModelOperationServiceCreate(EnablementLearningPathModelServiceCreate enablementLearningPathModelServiceCreate) {
        if (this.enablementLearningPathModelOperationServiceCreate == enablementLearningPathModelServiceCreate) {
            this.enablementLearningPathModelOperationServiceCreate = null;
        }
    }

    protected void bindEnablementLearningPathModelOperationServiceUpdate(EnablementLearningPathModelServiceUpdate enablementLearningPathModelServiceUpdate) {
        this.enablementLearningPathModelOperationServiceUpdate = enablementLearningPathModelServiceUpdate;
    }

    protected void unbindEnablementLearningPathModelOperationServiceUpdate(EnablementLearningPathModelServiceUpdate enablementLearningPathModelServiceUpdate) {
        if (this.enablementLearningPathModelOperationServiceUpdate == enablementLearningPathModelServiceUpdate) {
            this.enablementLearningPathModelOperationServiceUpdate = null;
        }
    }

    protected void bindEnablementLearningPathModelOperationServicePublish(EnablementLearningPathModelServicePublish enablementLearningPathModelServicePublish) {
        this.enablementLearningPathModelOperationServicePublish = enablementLearningPathModelServicePublish;
    }

    protected void unbindEnablementLearningPathModelOperationServicePublish(EnablementLearningPathModelServicePublish enablementLearningPathModelServicePublish) {
        if (this.enablementLearningPathModelOperationServicePublish == enablementLearningPathModelServicePublish) {
            this.enablementLearningPathModelOperationServicePublish = null;
        }
    }
}

