/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.enablement.resource.endpoints.api;

import com.adobe.cq.social.enablement.resource.endpoints.api.EnablementResourceModelOperations;
import com.adobe.cq.social.enablement.resource.endpoints.api.EnablementResourceModelServiceCreate;
import com.adobe.cq.social.enablement.resource.endpoints.api.EnablementResourceModelServiceDelete;
import com.adobe.cq.social.enablement.resource.endpoints.api.EnablementResourceModelServicePublish;
import com.adobe.cq.social.enablement.resource.endpoints.api.EnablementResourceModelServiceReport;
import com.adobe.cq.social.enablement.resource.endpoints.api.EnablementResourceModelServiceUpdate;
import com.adobe.cq.social.enablement.resource.model.api.EnablementResourceModel;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import java.util.Map;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
@Properties(value={@Property(name="fieldWhitelist", value={}, description="List of allowed whitelisted custom properties", cardinality=100)})
public abstract class AbstractEnablementResourceModelOperationService<T extends OperationExtension, U extends Operation>
extends AbstractOperationService<T, U, EnablementResourceModel>
implements EnablementResourceModelOperations {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Reference
    private EnablementResourceModelServiceCreate enablementResourceModelOperationCreateService;
    @Reference
    private EnablementResourceModelServiceUpdate enablementResourceModelOperationUpdateService;
    @Reference
    private EnablementResourceModelServiceDelete enablementResourceModelOperationDeleteService;
    @Reference
    private EnablementResourceModelServiceReport enablementResourceModelOperationReportService;
    @Reference
    private EnablementResourceModelServicePublish enablementResourceModelOperationPublishService;
    protected String[] fieldWhitelist;
    protected static final String PROPERTY_FIELD_WHITELIST = "fieldWhitelist";

    @Activate
    protected void activate(ComponentContext context) {
        Object whitelist = context.getProperties().get(PROPERTY_FIELD_WHITELIST);
        this.fieldWhitelist = PropertiesUtil.toStringArray(whitelist);
    }

    @Override
    public SocialComponent report(SlingHttpServletRequest request) throws OperationException {
        try {
            this.LOGGER.debug("Enablement Resource Model Report operation.");
            Map<String, Object> properties = this.enablementResourceModelOperationReportService.getOperationProperties(request, this.fieldWhitelist);
            U reportOperation = this.getReportOperation();
            Resource parentResource = request.getResource();
            ResourceResolver resolver = parentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(reportOperation, session, parentResource, properties);
            EnablementResourceModel enablementResourceModel = this.enablementResourceModelOperationReportService.report(request, properties);
            if (enablementResourceModel != null) {
                this.performAfterActions(reportOperation, session, enablementResourceModel, properties);
                return enablementResourceModel;
            }
        }
        catch (Exception e) {
            throw new OperationException("Internal error creating enablementResourceModel.", e, 500);
        }
        throw new OperationException("Unable to obtain EnablementResourceModel component.", 500);
    }

    @Override
    public void delete(SlingHttpServletRequest request) throws OperationException {
        try {
            this.LOGGER.debug("Enablement Resource Model Publish/Unpublish operation.");
            Map<String, Object> properties = this.enablementResourceModelOperationDeleteService.getOperationProperties(request, this.fieldWhitelist);
            U deleteOperation = this.getDeleteOperation();
            Resource parentResource = request.getResource();
            ResourceResolver resolver = parentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(deleteOperation, session, parentResource, properties);
            this.enablementResourceModelOperationDeleteService.delete(request, properties);
            this.performAfterActions(deleteOperation, session, null, properties);
        }
        catch (Exception e) {
            throw new OperationException("Internal error deleting enablementResourceModel.", e, 500);
        }
    }

    @Override
    public SocialComponent publish(SlingHttpServletRequest request) throws OperationException {
        try {
            this.LOGGER.debug("Enablement Resource Model Publish/Unpublish operation.");
            Map<String, Object> properties = this.enablementResourceModelOperationPublishService.getOperationProperties(request, this.fieldWhitelist);
            U publishOperation = this.getPublishOperation();
            Resource parentResource = request.getResource();
            ResourceResolver resolver = parentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(publishOperation, session, parentResource, properties);
            EnablementResourceModel enablementResourceModel = this.enablementResourceModelOperationPublishService.publish(request, properties);
            if (enablementResourceModel != null) {
                this.performAfterActions(publishOperation, session, enablementResourceModel, properties);
                return enablementResourceModel;
            }
        }
        catch (Exception e) {
            throw new OperationException("Internal error publishing/unpublishing enablementResourceModel.", e, 500);
        }
        throw new OperationException("Unable to obtain EnablementResourceModel component.", 500);
    }

    @Override
    public SocialComponent create(SlingHttpServletRequest request) throws OperationException {
        try {
            this.LOGGER.debug("Enablement Resource Model Create operation.");
            Map<String, Object> properties = this.enablementResourceModelOperationCreateService.getOperationProperties(request, this.fieldWhitelist);
            U createOperation = this.getCreateOperation();
            Resource parentResource = request.getResource();
            ResourceResolver resolver = parentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(createOperation, session, parentResource, properties);
            EnablementResourceModel enablementResourceModel = this.enablementResourceModelOperationCreateService.create(request, properties);
            if (enablementResourceModel != null) {
                this.performAfterActions(createOperation, session, enablementResourceModel, properties);
                return enablementResourceModel;
            }
        }
        catch (Exception e) {
            throw new OperationException("Internal error creating enablementResourceModel.", e, 500);
        }
        throw new OperationException("Unable to obtain EnablementResourceModel component.", 500);
    }

    @Override
    public SocialComponent update(SlingHttpServletRequest request) throws OperationException {
        try {
            this.LOGGER.debug("Enablement Resource Model Create operation.");
            Map<String, Object> properties = this.enablementResourceModelOperationUpdateService.getOperationProperties(request, this.fieldWhitelist);
            U updateOperation = this.getUpdateOperation();
            Resource parentResource = request.getResource();
            ResourceResolver resolver = parentResource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            this.performBeforeActions(updateOperation, session, parentResource, properties);
            EnablementResourceModel enablementResourceModel = this.enablementResourceModelOperationUpdateService.update(request, properties, this.fieldWhitelist);
            if (enablementResourceModel != null) {
                this.performAfterActions(updateOperation, session, enablementResourceModel, properties);
                return enablementResourceModel;
            }
        }
        catch (Exception e) {
            throw new OperationException("Internal error modify enablementResourceModel.", e, 500);
        }
        throw new OperationException("Unable to obtain EnablementResourceModel component.", 500);
    }

    protected String getResourceType() {
        return "social/enablement/components/hbs/model/resource";
    }

    protected abstract U getCreateOperation();

    protected abstract U getUpdateOperation();

    protected abstract U getDeleteOperation();

    protected abstract U getReportOperation();

    protected abstract U getPublishOperation();

    protected void bindEnablementResourceModelOperationCreateService(EnablementResourceModelServiceCreate enablementResourceModelServiceCreate) {
        this.enablementResourceModelOperationCreateService = enablementResourceModelServiceCreate;
    }

    protected void unbindEnablementResourceModelOperationCreateService(EnablementResourceModelServiceCreate enablementResourceModelServiceCreate) {
        if (this.enablementResourceModelOperationCreateService == enablementResourceModelServiceCreate) {
            this.enablementResourceModelOperationCreateService = null;
        }
    }

    protected void bindEnablementResourceModelOperationUpdateService(EnablementResourceModelServiceUpdate enablementResourceModelServiceUpdate) {
        this.enablementResourceModelOperationUpdateService = enablementResourceModelServiceUpdate;
    }

    protected void unbindEnablementResourceModelOperationUpdateService(EnablementResourceModelServiceUpdate enablementResourceModelServiceUpdate) {
        if (this.enablementResourceModelOperationUpdateService == enablementResourceModelServiceUpdate) {
            this.enablementResourceModelOperationUpdateService = null;
        }
    }

    protected void bindEnablementResourceModelOperationDeleteService(EnablementResourceModelServiceDelete enablementResourceModelServiceDelete) {
        this.enablementResourceModelOperationDeleteService = enablementResourceModelServiceDelete;
    }

    protected void unbindEnablementResourceModelOperationDeleteService(EnablementResourceModelServiceDelete enablementResourceModelServiceDelete) {
        if (this.enablementResourceModelOperationDeleteService == enablementResourceModelServiceDelete) {
            this.enablementResourceModelOperationDeleteService = null;
        }
    }

    protected void bindEnablementResourceModelOperationReportService(EnablementResourceModelServiceReport enablementResourceModelServiceReport) {
        this.enablementResourceModelOperationReportService = enablementResourceModelServiceReport;
    }

    protected void unbindEnablementResourceModelOperationReportService(EnablementResourceModelServiceReport enablementResourceModelServiceReport) {
        if (this.enablementResourceModelOperationReportService == enablementResourceModelServiceReport) {
            this.enablementResourceModelOperationReportService = null;
        }
    }

    protected void bindEnablementResourceModelOperationPublishService(EnablementResourceModelServicePublish enablementResourceModelServicePublish) {
        this.enablementResourceModelOperationPublishService = enablementResourceModelServicePublish;
    }

    protected void unbindEnablementResourceModelOperationPublishService(EnablementResourceModelServicePublish enablementResourceModelServicePublish) {
        if (this.enablementResourceModelOperationPublishService == enablementResourceModelServicePublish) {
            this.enablementResourceModelOperationPublishService = null;
        }
    }
}

