/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.filelibrary.client.api;

import com.adobe.cq.social.commons.comments.api.AbstractCommentCollection;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.filelibrary.client.api.AbstractFileLibraryConfiguration;
import com.adobe.cq.social.filelibrary.client.api.Asset;
import com.adobe.cq.social.filelibrary.client.api.FileLibrary;
import com.adobe.cq.social.filelibrary.client.api.FileLibraryConfiguration;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public abstract class AbstractFileLibrary<P extends Asset, C extends FileLibraryConfiguration>
extends AbstractCommentCollection<P, C>
implements FileLibrary<P, C> {
    private final String title;
    private final boolean isClosed;
    private FileLibraryConfiguration configuration;

    public AbstractFileLibrary(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager) {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    public AbstractFileLibrary(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager) {
        super(resource, clientUtils, queryInfo, listProviderManager);
        ResourceResolver resolver = resource.getResourceResolver();
        PageManager pageManager = resolver.adaptTo(PageManager.class);
        ValueMap properties = ResourceUtil.getValueMap(resource);
        if (null != pageManager) {
            Page page = pageManager.getContainingPage(resource);
            this.title = page.getTitle();
        } else {
            this.title = null;
        }
        this.isClosed = properties.get("closed", false);
    }

    @Override
    @JsonProperty(value="isClosed")
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTitle() {
        return this.title;
    }

    @Override
    public C createConfiguration(Resource resource) {
        return (C)new AbstractFileLibraryConfiguration(resource);
    }
}

