/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.graph.client.api;

import com.adobe.cq.social.graph.Edge;
import com.adobe.cq.social.graph.SocialGraph;
import com.adobe.cq.social.graph.Vertex;
import com.adobe.cq.social.graph.client.api.RelationshipCollection;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.User;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.Relationship;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRelationshipCollection
extends BaseSocialComponent
implements RelationshipCollection {
    private final ResourceResolver resolver;
    private final SocialGraph graph;
    private final Direction direction;
    private final String relType;
    private String userId;
    private List<Object> socialComponents;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRelationshipCollection.class);
    private static String PROP_USERID = "userId";
    private static final String PROP_OUTGOING_DIRECTION = "outgoing";
    private static final String PROP_REL_TYPE = "relType";

    public AbstractRelationshipCollection(Resource resource, ClientUtilities clientUtils, QueryRequestInfo requestInfo) {
        super(resource, clientUtils);
        this.resolver = resource.getResourceResolver();
        this.graph = this.resolver.adaptTo(SocialGraph.class);
        ValueMap properties = resource.getValueMap();
        Boolean outgoing = properties.get(PROP_OUTGOING_DIRECTION, Boolean.TRUE);
        this.relType = properties.get(PROP_REL_TYPE, "");
        this.direction = outgoing != false ? Direction.OUTGOING : Direction.INCOMING;
        try {
            this.userId = this.getUserId(properties, this.resolver.adaptTo(UserPropertiesManager.class));
        }
        catch (RepositoryException e) {
            LOG.error("Unable to find a user to list relationships for", e);
            this.userId = null;
        }
    }

    protected String getUserId(ValueMap properties, UserPropertiesManager upm) throws RepositoryException {
        String userIdSuffix;
        String userIdFromProps = properties.get(PROP_USERID, "");
        if (!StringUtils.isEmpty(userIdFromProps)) {
            return userIdFromProps;
        }
        String string = userIdSuffix = this.clientUtils.getRequest() == null ? null : this.clientUtils.getRequest().getRequestPathInfo().getSuffix();
        if (!StringUtils.isEmpty(userIdSuffix)) {
            if (StringUtils.endsWith(userIdSuffix, "/profile")) {
                UserProperties up = upm.getUserProperties(this.clientUtils.getRequest().getRequestPathInfo().getSuffixResource().adaptTo(Node.class));
                return up.getAuthorizableID();
            }
            return userIdSuffix;
        }
        return this.resolver.getUserID();
    }

    @Override
    public int getTotalSize() {
        this.getItems();
        return this.socialComponents != null ? this.socialComponents.size() : 0;
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
    }

    @Override
    public List<Object> getItems() {
        if (this.socialComponents == null && this.graph != null && this.direction != null && StringUtils.isNotEmpty(this.userId)) {
            Vertex node = this.graph.getVertex(this.userId);
            this.socialComponents = new ArrayList<Object>();
            if (node != null) {
                for (Relationship relationship : node.getRelationships(this.relType, this.direction, this.getRelationshipType())) {
                    String id;
                    if (relationship.isVirtual()) continue;
                    Edge sr = (Edge)relationship;
                    String string = id = this.direction == Direction.INCOMING ? sr.getStartId() : sr.getEndId();
                    if (id.startsWith("/")) {
                        this.socialComponents.add(this.createSocialComponent(id));
                        continue;
                    }
                    this.socialComponents.add(this.createCommunityUser(id));
                }
            }
        }
        return this.socialComponents;
    }

    protected String getRelationshipType() {
        return "following";
    }

    private SocialComponent createSocialComponent(String id) {
        SocialComponentFactory scf;
        Resource resource;
        SocialComponentFactoryManager scfMgr;
        if (StringUtils.isNotBlank(id) && (scfMgr = this.clientUtils.getSocialComponentFactoryManager()) != null && (resource = this.resolver.getResource(id)) != null && (scf = scfMgr.getSocialComponentFactory(resource)) != null) {
            return scf.getSocialComponent(resource, this.clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create());
        }
        return null;
    }

    private User createCommunityUser(String id) {
        return this.clientUtils.getUser(id, this.resolver);
    }
}

