/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialCollectionComponentFactory;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.site.impl.CommunitySiteImpl;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;

@Component
@Service
public class CommunitySiteComponentFactory
extends AbstractSocialComponentFactory
implements SocialCollectionComponentFactory {
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        try {
            return new CommunitySiteImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.serviceUserWrapper, this.resourceResolverFactory);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        try {
            return new CommunitySiteImpl(resource, this.getClientUtilities(request), this.serviceUserWrapper, this.resourceResolverFactory);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo) {
        try {
            return new CommunitySiteImpl(resource, clientUtils, this.serviceUserWrapper, this.resourceResolverFactory);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public String getSupportedResourceType() {
        return "social/console/components/hbs/sitecollection/site";
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

