/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import com.adobe.cq.social.srp.SocialResource;
import com.adobe.cq.social.srp.SocialResourceProvider;
import com.adobe.cq.social.srp.config.SRPConfigurationError;
import com.adobe.cq.social.srp.config.SRPConfigurationFactory;
import com.adobe.cq.social.srp.config.SocialResourceConfiguration;
import com.adobe.cq.social.srp.internal.Configuration;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.management.ServiceNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocialResourceUtils {
    public static String GRAVATAR_PREFIX = "https://www.gravatar.com/avatar/";
    public static final String PATH_UGC = "/content/usergenerated";
    public static final String ASI_UGC_PREFIX = "/content/usergenerated/asi";
    public static final String DEFAULT_AVATAR = "/etc.clientlibs/settings/wcm/designs/default/resources/social/avatar.png";
    public static final String CC_ASIPATH = "asipath";
    public static final String CC_HOST_URL = "hosturl";
    public static final String CC_REPORT_SUITE = "reportsuite";
    public static final String CC_CONSUMER_KEY = "consumerkey";
    public static final String CC_SECRET_KEY = "secret";
    public static final String SRP_CONFIGURATION_CONF_ROOT = "/conf/global/settings/community/srpc/";
    public static final String SRP_CONFIGURATION_ROOT = "/etc/socialconfig/srpc/";
    public static final String SRP_DEFAULT_CONFIG_CONF_PATH = "/conf/global/settings/community/srpc/defaultconfiguration";
    public static final String SRP_DEFAULT_CONFIG_PATH = "/etc/socialconfig/srpc/defaultconfiguration";
    private static final Logger LOG = LoggerFactory.getLogger(SocialResourceUtils.class);
    private static ServiceTracker tracker;

    private SocialResourceUtils() {
    }

    public static Boolean checkPermission(ResourceResolver resolver, String path, String action) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        try {
            Session userSession = resolver.adaptTo(Session.class);
            return userSession.hasPermission(path, action);
        }
        catch (RepositoryException e) {
            return SocialResourceUtils.checkPermission(resolver, StringUtils.substringBeforeLast(path, "/"), action);
        }
    }

    @Deprecated
    public static com.day.cq.wcm.webservicesupport.Configuration getFirstCloudStorageConfig(ResourceResolver resolver) {
        SocialResourceConfiguration srConfig;
        Configuration config;
        block8: {
            Resource configResource;
            config = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("STATIC getDefaultStorageConfig called. Please use SocialUtils", new Throwable("getDefaultStorageConfig"));
            }
            if ((configResource = resolver.getResource(SRP_DEFAULT_CONFIG_PATH)) == null) {
                configResource = resolver.getResource(SRP_DEFAULT_CONFIG_CONF_PATH);
            }
            srConfig = null;
            try {
                if (configResource == null) break block8;
                LOG.debug("config resource is: {}", (Object)configResource.getPath());
                try {
                    srConfig = SocialResourceUtils.getConfigFactory().createConfiguration(configResource);
                }
                catch (ServiceNotFoundException e) {
                    throw new SRPConfigurationError(e);
                }
            }
            catch (SRPConfigurationError e) {
                LOG.error("Could not build configuration: ", e);
            }
        }
        if (srConfig != null) {
            config = new Configuration(srConfig);
        }
        if (srConfig != null) {
            LOG.debug("getFirstCloudStorageConfig asipath is: {} ", (Object)srConfig.getAsiPath());
        }
        return config;
    }

    public static UserProperties getUserProperties(ResourceResolver resolver, String userId) {
        UserProperties userProperties = null;
        UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
        if (null != upm && null != userId) {
            try {
                userProperties = upm.getUserProperties(userId, "profile");
            }
            catch (RepositoryException e) {
                LOG.warn("User cannot access the profile.", e);
            }
        }
        return userProperties;
    }

    public static String getAvatar(UserProperties userProperties, String absoluteDefaultAvatar, AVATAR_SIZE size) {
        return SocialResourceUtils.buildAvatar(userProperties, absoluteDefaultAvatar, size.toString());
    }

    public static String getAvatar(UserProperties userProperties, String absoluteDefaultAvatar, String size) {
        return SocialResourceUtils.buildAvatar(userProperties, absoluteDefaultAvatar, size);
    }

    private static String buildAvatar(UserProperties userProperties, String absoluteDefaultAvatar, String size) {
        String avatar = DEFAULT_AVATAR;
        int iSize = AVATAR_SIZE.THIRTY_TWO.ordinal();
        try {
            iSize = Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            LOG.warn("Bad size passed in, defaulting size.", e);
        }
        if (userProperties != null) {
            try {
                Resource resource = userProperties.getResource("photos/primary/image");
                if (null != resource) {
                    avatar = resource.getPath() + ".prof.thumbnail." + Integer.toString(iSize) + ".png";
                } else {
                    String gravatar;
                    String primaryMail = userProperties.getProperty("email");
                    if (primaryMail != null && !"".equals(primaryMail) && (gravatar = SocialResourceUtils.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                        avatar = gravatar;
                    }
                }
            }
            catch (RepositoryException e) {
                LOG.error("getAvatar: error getting avatar: ", e);
            }
        }
        return avatar;
    }

    private static String getGravatar(String email, String absoluteDefaultAvatar) {
        if (StringUtils.isBlank(email) || StringUtils.isBlank(absoluteDefaultAvatar)) {
            return null;
        }
        try {
            email = Text.md5(email, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append(GRAVATAR_PREFIX);
        sb.append(email);
        sb.append("?d=").append("mm");
        sb.append("&s=32");
        sb.append("&r=g");
        return sb.toString();
    }

    public static boolean isCloudUGC(String path) {
        return StringUtils.startsWith(path, ASI_UGC_PREFIX);
    }

    public static boolean isSocialResource(Resource res) {
        if (res instanceof SocialResource) {
            return true;
        }
        if (res instanceof ResourceWrapper) {
            return SocialResourceUtils.isSocialResource(((ResourceWrapper)res).getResource());
        }
        return false;
    }

    public static SocialResource getSocialResource(Resource res) {
        if (res == null) {
            return null;
        }
        if (res instanceof SocialResource) {
            return (SocialResource)res;
        }
        if (res instanceof ResourceWrapper) {
            return SocialResourceUtils.getSocialResource(((ResourceWrapper)res).getResource());
        }
        if (res instanceof NonExistingResource) {
            LOG.warn("Resource {} is a NonExistingResource, returning null", (Object)res);
            return null;
        }
        LOG.debug("Resource {} is unknown resource type, returning null", (Object)res);
        return null;
    }

    public static boolean causeByInvalidItemStateException(Exception e) {
        Throwable cause = e;
        do {
            if (!(cause instanceof InvalidItemStateException)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    private static SRPConfigurationFactory getConfigFactory() throws ServiceNotFoundException {
        Object factory = tracker.getService();
        if (factory != null && factory instanceof SRPConfigurationFactory) {
            return (SRPConfigurationFactory)factory;
        }
        throw new ServiceNotFoundException();
    }

    public static String getUniqueUGCResourceName(ResourceResolver resourceResolver, String ugcPath, SocialResourceProvider resourceProvider, String nodeName) {
        Resource newResource = resourceProvider.getResource(resourceResolver, ugcPath + "/" + nodeName);
        if (newResource != null) {
            String leafNodeName;
            int i = 0;
            do {
                leafNodeName = nodeName + "_" + String.valueOf(i);
                ++i;
            } while ((newResource = resourceProvider.getResource(resourceResolver, ugcPath + "/" + leafNodeName)) != null);
            return leafNodeName;
        }
        return nodeName;
    }

    public static enum AVATAR_SIZE {
        THIRTY_TWO(32),
        FOURTY_EIGHT(48),
        EIGHTY(80),
        THIRTY_FOUR(34);

        private final int size;

        private AVATAR_SIZE(int s) {
            this.size = s;
        }

        public String toString() {
            return String.valueOf(this.size);
        }
    }
}

