/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.utilities.internal;

import com.adobe.cq.social.srp.SocialResource;
import com.adobe.cq.social.srp.config.SRPConfigurationFactory;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalStaticResourceUtilities
implements BundleActivator {
    private static String GRAVATAR_PREFIX = "http://www.gravatar.com/avatar/";
    private static final Logger LOG = LoggerFactory.getLogger(InternalStaticResourceUtilities.class);
    private static ServiceTracker tracker;

    private InternalStaticResourceUtilities() {
    }

    public static Boolean checkPermission(ResourceResolver resolver, String path, String action) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        try {
            Session userSession = resolver.adaptTo(Session.class);
            return userSession.hasPermission(path, action);
        }
        catch (RepositoryException e) {
            return InternalStaticResourceUtilities.checkPermission(resolver, StringUtils.substringBeforeLast(path, "/"), action);
        }
    }

    public static UserProperties getUserProperties(ResourceResolver resolver, String userId) {
        UserProperties userProperties = null;
        UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
        if (null != upm && null != userId) {
            try {
                userProperties = upm.getUserProperties(userId, "profile");
            }
            catch (RepositoryException e) {
                LOG.warn("User cannot access the profile.", e);
            }
        }
        return userProperties;
    }

    public static boolean isCloudUGC(String path) {
        return StringUtils.startsWith(path, "/content/usergenerated/asi");
    }

    public static boolean isSocialResource(Resource res) {
        if (res instanceof SocialResource) {
            return true;
        }
        if (res instanceof ResourceWrapper) {
            return InternalStaticResourceUtilities.isSocialResource(((ResourceWrapper)res).getResource());
        }
        return false;
    }

    public static SocialResource getSocialResource(Resource res) {
        if (res == null) {
            return null;
        }
        if (res instanceof SocialResource) {
            return (SocialResource)res;
        }
        if (res instanceof ResourceWrapper) {
            return InternalStaticResourceUtilities.getSocialResource(((ResourceWrapper)res).getResource());
        }
        if (res instanceof NonExistingResource) {
            LOG.warn("Resource {} is a NonExistingResource, returning null", (Object)res);
            return null;
        }
        LOG.debug("Resource {} is unknown resource type, returning null", (Object)res);
        return null;
    }

    public static boolean causeByInvalidItemStateException(Exception e) {
        Throwable cause = e;
        do {
            if (!(cause instanceof InvalidItemStateException)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    public static Node getOrCreateByPathDepthFirst(String path, boolean createUniqueLeaf, String intermediateNodeType, String nodeType, Session session, boolean autoSave) throws RepositoryException {
        String createPath;
        String workingPath;
        String string = workingPath = path.startsWith("/") ? path : "/" + path;
        if (workingPath.endsWith("/")) {
            workingPath = workingPath.substring(0, workingPath.length() - 1);
        }
        String checkPath = Text.getRelativeParent(workingPath, 1);
        Node base = null;
        do {
            if (!session.nodeExists(checkPath)) continue;
            base = session.getNode(checkPath);
            break;
        } while (!(checkPath = Text.getRelativeParent(checkPath, 1)).isEmpty() && !"/".equals(checkPath));
        if (base == null) {
            try {
                base = session.getRootNode();
            }
            catch (AccessDeniedException ade) {
                throw new AccessDeniedException("Failed to access root node for the creation of " + path, ade);
            }
        }
        if ((createPath = workingPath.substring(checkPath.length())).startsWith("/")) {
            createPath = createPath.substring(1);
        }
        return JcrUtils.getOrCreateByPath(base, createPath, false, intermediateNodeType, nodeType, autoSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        Class<InternalStaticResourceUtilities> clazz = InternalStaticResourceUtilities.class;
        synchronized (InternalStaticResourceUtilities.class) {
            if (tracker == null) {
                tracker = new ServiceTracker(context, SRPConfigurationFactory.class.getName(), null);
                tracker.open();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(BundleContext context) throws Exception {
        Class<InternalStaticResourceUtilities> clazz = InternalStaticResourceUtilities.class;
        synchronized (InternalStaticResourceUtilities.class) {
            if (tracker != null) {
                tracker.close();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

