/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.api;

import com.adobe.cq.social.SocialException;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseQueryRequestInfo;
import com.adobe.cq.social.user.endpoints.impl.CommunityAuthorizableCollectionImpl;
import com.adobe.cq.social.user.internal.HttpToPublisher;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class CommunityAuthorizableCollectionComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    @Reference
    private SlingRepository repository;
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    private HttpToPublisher httpPublish;
    @Reference
    protected SlingSettingsService settingsService;
    private static final Logger LOG = LoggerFactory.getLogger(CommunityAuthorizableCollectionComponentFactory.class);
    public static String FROM_PUBLISHER = "fromPublisher";
    private static final String SHOW_GROUPS = "showGroups";
    private static final String AUTHORIZABLE_TYPE = "type";
    private static final String USER_TYPE = "users";
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static String PAGE_SIZE_PN = "pageSize";

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        throw new UnsupportedOperationException("getSocialComponent(Resource) is not supported.");
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest req) {
        return this.getSocialComponent(resource, this.getClientUtilities(req), new BaseQueryRequestInfo(req, false));
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities c, QueryRequestInfo q) {
        ValueMap resourceProps = resource.getValueMap();
        int pageSizeConfig = resourceProps.get(PAGE_SIZE_PN, 10);
        CollectionPagination paginationFromQuery = q.getPagination();
        int pageSize = q.getPagination() == CollectionPagination.DEFAULT_PAGINATION ? pageSizeConfig : paginationFromQuery.getSize();
        q.setPagination(new CollectionPagination(paginationFromQuery.getOffset(), pageSize, paginationFromQuery.getEmbedLevel(), paginationFromQuery.getSortIndex(), pageSizeConfig));
        Map<String, String[]> predicates = q.getPredicates();
        boolean usePublish = predicates.get(FROM_PUBLISHER) != null ? StringUtils.equalsIgnoreCase(predicates.get(FROM_PUBLISHER)[0], "true") : (resource != null && resource.adaptTo(ValueMap.class) != null ? StringUtils.equalsIgnoreCase(resource.adaptTo(ValueMap.class).get(FROM_PUBLISHER, "false"), "true") : false);
        if (usePublish && this.isAuthorMode()) {
            if (this.httpPublish.isEnabled()) {
                return this.httpPublish.getFromPublisher(resource, q);
            }
            LOG.warn("User list operation is from Author because Tunnel service is no enabled.");
        }
        try {
            UserManager userManager = AccessControlUtil.getUserManager(c.getRequest().getResourceResolver().adaptTo(Session.class));
            CommunityAuthorizableCollectionImpl collection = new CommunityAuthorizableCollectionImpl(resource, c, userManager, q);
            return collection;
        }
        catch (RepositoryException e) {
            LOG.error("Failed to obtain user manager", e);
            throw new SocialException("Error creating TenantUserCollection.", e);
        }
    }

    protected void closeAdminSession(Session adminSession) {
        if (adminSession != null && adminSession.isLive()) {
            adminSession.logout();
        }
    }

    @Override
    public String getSupportedResourceType() {
        return "social/console/components/hbs/users";
    }

    private boolean isAuthorMode() {
        return this.settingsService != null && this.settingsService.getRunModes().contains("author");
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindHttpPublish(HttpToPublisher httpToPublisher) {
        this.httpPublish = httpToPublisher;
    }

    protected void unbindHttpPublish(HttpToPublisher httpToPublisher) {
        if (this.httpPublish == httpToPublisher) {
            this.httpPublish = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

