/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.api;

import com.adobe.cq.social.badging.api.BadgingService;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.scoring.api.ScoringService;
import com.adobe.cq.social.user.endpoints.impl.CommunityUserImpl;
import com.adobe.granite.security.user.UserPropertiesManager;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="AEM Communities TenantUserSocialComponentFactory")
@Service
public class CommunityUserComponentFactory
extends AbstractSocialComponentFactory {
    @Reference
    private ScoringService scoring;
    @Reference
    private BadgingService badging;
    private static final Logger LOG = LoggerFactory.getLogger(CommunityUserComponentFactory.class);

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        try {
            return new CommunityUserImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.getUserPropertiesManager(resource), this.scoring, this.badging);
        }
        catch (RepositoryException e) {
            LOG.error("Error creating TenantUser", e);
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        try {
            return new CommunityUserImpl(resource, this.getClientUtilities(request), request.getResourceResolver().adaptTo(UserPropertiesManager.class), this.scoring, this.badging);
        }
        catch (RepositoryException e) {
            LOG.error("Error creating TenantUser", e);
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo requestInfo) {
        try {
            return new CommunityUserImpl(resource, clientUtils, this.getUserPropertiesManager(resource), this.scoring, this.badging);
        }
        catch (RepositoryException e) {
            LOG.error("Error creating TenantUser", e);
            return null;
        }
    }

    protected UserPropertiesManager getUserPropertiesManager(Resource resource) {
        return resource.getResourceResolver().adaptTo(UserPropertiesManager.class);
    }

    @Override
    public String getSupportedResourceType() {
        return "social/console/components/hbs/users/user";
    }

    protected void bindScoring(ScoringService scoringService) {
        this.scoring = scoringService;
    }

    protected void unbindScoring(ScoringService scoringService) {
        if (this.scoring == scoringService) {
            this.scoring = null;
        }
    }

    protected void bindBadging(BadgingService badgingService) {
        this.badging = badgingService;
    }

    protected void unbindBadging(BadgingService badgingService) {
        if (this.badging == badgingService) {
            this.badging = null;
        }
    }
}

