/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.user.impl.UserProfileImpl;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="AEM Communities UserProfileComponentFactory")
@Service
public class UserProfileComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UserProfileComponentFactory.class);

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        try {
            return new UserProfileImpl(resource, this.getClientUtilities(resource.getResourceResolver()));
        }
        catch (RepositoryException e) {
            LOG.error("Error creating UserProfile", e);
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        try {
            Resource targetUser;
            Object item;
            Object formForwarderValue = request.getAttribute("cq.form.editresources");
            if (formForwarderValue instanceof List && ((List)formForwarderValue).size() == 1 && (item = ((List)formForwarderValue).get(0)) instanceof Resource && (targetUser = (Resource)item) != null) {
                return new UserProfileImpl(targetUser, this.getClientUtilities(request));
            }
            return new UserProfileImpl(resource, this.getClientUtilities(request));
        }
        catch (RepositoryException e) {
            LOG.error("Error creating UserProfile", e);
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo requestInfo) {
        try {
            return new UserProfileImpl(resource, clientUtils);
        }
        catch (RepositoryException e) {
            LOG.error("Error creating UserProfile", e);
            return null;
        }
    }

    @Override
    public String getSupportedResourceType() {
        return "social/console/components/hbs/userprofile";
    }
}

