/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.internal;

import com.adobe.cq.social.badging.api.BadgingService;
import com.adobe.cq.social.badging.api.UserBadge;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.user.internal.UserProfileBadge;
import com.adobe.cq.social.user.internal.UserProfileBadgeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserBadgeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UserBadgeUtils.class);
    protected final String userId;
    protected final ResourceResolver resourceResolver;
    protected final BadgingService badgingService;

    public UserBadgeUtils(ResourceResolver resourceResolver, BadgingService badgingService) {
        this(resourceResolver, badgingService, resourceResolver.getUserID());
    }

    public UserBadgeUtils(ResourceResolver resourceResolver, BadgingService badgingService, String userId) {
        this.resourceResolver = resourceResolver;
        this.badgingService = badgingService;
        this.userId = userId;
    }

    public List<UserProfileBadge> getBadges(CommunityContext context, String badgeType) {
        return this.getFilteredBadges(this.getSiteBadges(context, badgeType), badgeType);
    }

    protected UserProfileBadge getUserProfileBadge(UserBadge userBadge) {
        return new UserProfileBadgeImpl(userBadge);
    }

    public List<UserProfileBadge> getSiteBadges(CommunityContext context, String badgeType) {
        List<UserProfileBadge> badges = this.getBadges(null, null, badgeType);
        if (context != null) {
            ArrayList<UserProfileBadge> removeBadges = new ArrayList<UserProfileBadge>();
            String sitePagePath = context.getSitePagePath();
            for (UserProfileBadge badge : badges) {
                ValueMap map;
                if (badge.getUserBadgeResource() == null || (map = badge.getUserBadgeResource().adaptTo(ValueMap.class)).get("siteId_s", "").equals(context.getSiteId())) continue;
                String badgePagePath = map.get("rulePage_s", "/content");
                if (sitePagePath == null || sitePagePath.startsWith(badgePagePath)) continue;
                removeBadges.add(badge);
            }
            badges.removeAll(removeBadges);
        }
        return badges;
    }

    public List<UserProfileBadge> getFilteredBadges(List<UserProfileBadge> badges, String badgeType) {
        Collections.sort(badges, badgeType.equals("EARNED") || badgeType.equals("EARNED_TOP") ? new Comparator<UserProfileBadge>(){

            @Override
            public int compare(UserProfileBadge o1, UserProfileBadge o2) {
                return Double.compare(o2.getEarnedScore(), o1.getEarnedScore());
            }
        } : new Comparator<UserProfileBadge>(){

            @Override
            public int compare(UserProfileBadge o1, UserProfileBadge o2) {
                return o1.getTitle().compareToIgnoreCase(o2.getTitle());
            }
        });
        return badges;
    }

    public List<UserProfileBadge> getBadges(Resource pageResource, CommunityContext context, String badgeType) {
        try {
            List<UserBadge> userBadges = this.badgingService.getBadges(this.resourceResolver, this.userId, pageResource, context, badgeType);
            ArrayList<UserProfileBadge> userProfileBadges = new ArrayList<UserProfileBadge>();
            for (UserBadge userBadge : userBadges) {
                userProfileBadges.add(this.getUserProfileBadge(userBadge));
            }
            return userProfileBadges;
        }
        catch (RepositoryException e) {
            LOG.error("Failed to get badges for {}: {}", (Object)this.userId, (Object)e.toString());
            return new ArrayList<UserProfileBadge>();
        }
    }
}

