/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.common;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.FormsPortalPDFRenderService;
import com.adobe.fd.fp.service.SubmitDataService;
import com.adobe.fd.fp.service.SubmitMetadataService;
import com.adobe.fd.fp.service.SubmittedAFDataService;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.PropertyUtils;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public abstract class FPSubmitHandler
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 3269969870036990497L;
    @Reference
    protected FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected FormsPortalPDFRenderService fpPdfRenderService;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected SubmittedAFDataService fpSubmittedAFUserDataService;
    @Reference
    protected PortalUtilsComponent portalUtilsComponent;
    private final Logger log = LoggerFactory.getLogger(FPSubmitHandler.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JSONObject submitForm(Map<String, Object> options, Node formNode) throws FormsPortalException {
        if (options == null || formNode == null) {
            throw new FormsPortalException("ALC-FMP-001-048");
        }
        try {
            HashMap<String, Object> metadataParams = new HashMap<String, Object>();
            String formType = options.containsKey("formType") && options.get("formType") != null ? options.get("formType").toString() : "af";
            String formData = options.get("formData") != null ? options.get("formData").toString() : null;
            byte[] dorBytes = (byte[])options.get("pdf");
            metadataParams.put("formType", formType != null ? formType : "");
            metadataParams.put("nodeType", this.getNodeType());
            metadataParams.put("owner", options.get("owner"));
            metadataParams.put("formContainerPath", options.get("formContainerPath"));
            metadataParams.put("fileAttachmentMap", options.get("fileAttachmentMap"));
            metadataParams.put("renderPath", "/content/forms/portal/render");
            metadataParams.put("status", this.getStatus());
            metadataParams.put("submitType", options.get("submitType"));
            String contentType = (String)options.get("contentType");
            String dataType = null;
            if (!StringUtils.isNotEmpty(contentType)) throw new FormsPortalException("ALC-FMP-001-050");
            if (contentType.equals("application/json")) {
                dataType = "JSON";
            } else {
                if (!contentType.equals("application/xml")) throw new FormsPortalException("ALC-FMP-001-049");
                dataType = "XML";
            }
            metadataParams.put("dataType", dataType);
            this.filterAllowedMetadata(options, metadataParams);
            this.processAttachments((List)options.get("attachments"), metadataParams);
            this.processComputedMetadata((String)options.get("afSubmissionInfo"), metadataParams);
            boolean isDorAssociated = this.populateIndentification(formNode, formType, metadataParams);
            this.saveUserData(formData, formType, metadataParams);
            String locale = (String)options.get("locale");
            this.saveDor(isDorAssociated, dorBytes, formNode, formData, metadataParams, locale, (List)options.get("attachments"));
            this.saveAgreementData(options, metadataParams, formType);
            if (isDorAssociated) {
                metadataParams.put("sling:resourceType", "fd/fp/components/opensubmittedguide/xfaaf");
            } else {
                metadataParams.put("sling:resourceType", "fd/fp/components/opensubmittedguide/nonxfaaf");
                metadataParams.put("showDorClass", "__FP_display_none");
            }
            Date lastModified = new Date();
            metadataParams.put("jcr:lastModified", String.valueOf(lastModified.getTime()));
            if (!"mf".equals(formType)) return this.saveMetadata(metadataParams, Collections.singletonMap("owner", options.get("owner")));
            metadataParams.put("xdpRef", metadataParams.get("formPath"));
            metadataParams.put("submitUrl", options.get("submitUrl"));
            metadataParams.put("profile", options.get("profile"));
            return this.saveMetadata(metadataParams, Collections.singletonMap("owner", options.get("owner")));
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
    }

    private void saveAgreementData(Map<String, Object> options, Map<String, Object> metadataParams, String formType) throws Exception {
        if (options.containsKey("agreementData")) {
            String agreementData = (String)options.get("agreementData");
            metadataParams.put("agreementDataId", this.saveData(agreementData.getBytes(), this.getSaveDataParams(agreementData, formType, metadataParams)));
            metadataParams.remove("agreementData");
        }
    }

    protected void filterAllowedMetadata(Map<String, Object> options, Map<String, Object> metadataParams) {
        String fpAllowedMetadata;
        String string = fpAllowedMetadata = options.containsKey("fpAllowedMetadata") && options.get("fpAllowedMetadata") != null ? options.get("fpAllowedMetadata").toString() : "";
        if (options != null && metadataParams != null && !StringUtils.isEmpty(fpAllowedMetadata)) {
            String[] fpAllowedMetadataArr;
            for (String metadata : fpAllowedMetadataArr = fpAllowedMetadata.split(",")) {
                if (!options.containsKey(metadata)) continue;
                metadataParams.put(metadata, options.get(metadata));
            }
        }
    }

    private void processAttachments(List<FileAttachmentWrapper> attachments, Map<String, Object> metadataParams) throws Exception {
        if (attachments != null && metadataParams != null) {
            ArrayList<String> attachmentKeyList = new ArrayList<String>();
            Map<String, Object> saveOptions = Collections.singletonMap("owner", metadataParams.get("owner"));
            for (FileAttachmentWrapper attachment : attachments) {
                String attachmentID = this.saveAttachment(IOUtils.toByteArray(attachment.getInputStream()), saveOptions);
                String attachmentKey = URLEncoder.encode(attachment.getFileName(), "UTF-8");
                metadataParams.put(attachmentKey, attachmentID);
                metadataParams.put(attachmentKey + "%2F" + "contentType", attachment.getContentType());
                attachmentKeyList.add(attachmentKey);
            }
            String[] attachmentKeys = new String[attachmentKeyList.size()];
            metadataParams.put("attachmentList", attachmentKeyList.toArray(attachmentKeys));
        }
    }

    private void processComputedMetadata(String submissionInfo, Map<String, Object> metadataParams) throws JSONException {
        JSONObject submissionInfoJSON;
        if (!StringUtils.isEmpty(submissionInfo) && metadataParams != null && (submissionInfoJSON = new JSONObject(submissionInfo)).has("computedMetaInfo")) {
            JSONObject computedMetadata = (JSONObject)submissionInfoJSON.get("computedMetaInfo");
            Iterator<String> computedMetaKeys = computedMetadata.keys();
            while (computedMetaKeys.hasNext()) {
                String computedMetaKey = computedMetaKeys.next();
                metadataParams.put(computedMetaKey, computedMetadata.get(computedMetaKey));
            }
        }
    }

    private boolean populateIndentification(Node formNode, String formType, Map<String, Object> metadataParams) throws ValueFormatException, PathNotFoundException, RepositoryException, Exception {
        boolean isDorAssociated = false;
        if (formNode != null && !StringUtils.isEmpty(formType) && metadataParams != null) {
            RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
            String formName = formNode.getName();
            String description = null;
            String formPath = formNode.getPath();
            if (formPath.startsWith("/content/dam/formsanddocuments")) {
                Node metadataNode = repUtils.getMetadataNode(formNode, false);
                if (metadataNode.hasProperty("description")) {
                    description = (String)PropertyUtils.getPropertyValue(metadataNode.getProperty("description"));
                }
                if (metadataNode.hasProperty("title") && !metadataNode.getProperty("title").getString().trim().isEmpty()) {
                    formName = (String)PropertyUtils.getPropertyValue(metadataNode.getProperty("title"));
                } else if (metadataNode.hasProperty("name") && !metadataNode.getProperty("name").getString().trim().isEmpty()) {
                    formName = (String)PropertyUtils.getPropertyValue(metadataNode.getProperty("name"));
                }
                isDorAssociated = PortalUtils.isDorAssociated(formType, metadataNode);
            } else {
                Node contentNode = repUtils.getContentNode(formNode, false);
                if (contentNode != null) {
                    if (contentNode.hasProperty("jcr:description")) {
                        description = (String)PropertyUtils.getPropertyValue(contentNode.getProperty("jcr:description"));
                    }
                    if (contentNode.hasProperty("jcr:title") && !contentNode.getProperty("jcr:title").getString().trim().isEmpty()) {
                        formName = (String)PropertyUtils.getPropertyValue(contentNode.getProperty("jcr:title"));
                    }
                }
            }
            metadataParams.put("formName", formName);
            metadataParams.put("formPath", formPath);
            metadataParams.put("description", description);
            metadataParams.put("name", formName);
        }
        return isDorAssociated;
    }

    private void saveUserData(String formData, String formType, Map<String, Object> metadataParams) throws Exception {
        if (!StringUtils.isEmpty(formData) && !StringUtils.isEmpty(formType) && metadataParams != null) {
            metadataParams.put("userdataID", this.saveData(formData.getBytes(StandardCharsets.UTF_8), this.getSaveDataParams(formData, formType, metadataParams)));
        }
    }

    protected void saveDor(boolean isDorAssociated, byte[] dorBytes, Node formNode, String formData, Map<String, Object> metadataParams, String locale, List<FileAttachmentWrapper> attachments) throws Exception {
        if (isDorAssociated) {
            metadataParams.put("sling:resourceType", "fd/fp/components/opensubmittedguide/xfaaf");
            if (dorBytes == null && this.fpPdfRenderService != null) {
                ArrayList<FileAttachmentWrapper> attachmentWrappers = new ArrayList<FileAttachmentWrapper>();
                for (FileAttachmentWrapper attachment : attachments) {
                    FileAttachmentWrapper attachmentWrapper = new FileAttachmentWrapper(URLEncoder.encode(attachment.getFileName(), "UTF-8"), attachment.getContentType(), attachment.getValue());
                    attachmentWrappers.add(attachmentWrapper);
                }
                dorBytes = this.fpPdfRenderService.getDorFromNode(formNode, formData.getBytes(), attachmentWrappers, locale);
            }
            if (dorBytes != null) {
                metadataParams.put("dorID", this.saveData(dorBytes, this.getSaveDataParams(formData, "af", metadataParams)));
            } else {
                this.log.warn("ALC-FMP-001-054");
            }
        }
    }

    private Map<String, Object> getSaveDataParams(String formData, String formType, Map<String, Object> metadataParams) {
        HashMap<String, Object> userdataParams = new HashMap<String, Object>();
        userdataParams.put("guideState", formData);
        userdataParams.put("guideName", (String)metadataParams.get("formName"));
        userdataParams.put("userdataID", null);
        userdataParams.put("formType", formType);
        userdataParams.put("owner", metadataParams.get("owner"));
        return userdataParams;
    }

    protected String saveData(byte[] formData, Map<String, Object> options) throws Exception {
        String userDataId = null;
        if (((String)options.get("formType")).equals("af") && this.fpSubmittedAFUserDataService != null) {
            userDataId = this.fpSubmittedAFUserDataService.submitAFUserData(options);
        } else {
            SubmitDataService fpSubmitDataService = (SubmitDataService)PortalUtils.getService(SubmitDataService.class, this.portalUtilsComponent.getSDSFilter());
            userDataId = fpSubmitDataService.saveData(null, formData);
        }
        return userDataId;
    }

    protected String saveAttachment(byte[] attachment, Map<String, Object> options) throws Exception {
        SubmitDataService fpSubmitDataService = (SubmitDataService)PortalUtils.getService(SubmitDataService.class, this.portalUtilsComponent.getSDSFilter());
        return fpSubmitDataService.saveAttachment(attachment);
    }

    protected JSONObject saveMetadata(Map<String, Object> metadataProps, Map<String, Object> saveOptions) throws Exception {
        SubmitMetadataService fpSubmitMetadataService = (SubmitMetadataService)PortalUtils.getService(SubmitMetadataService.class, this.portalUtilsComponent.getSMSFilter());
        JSONObject result = fpSubmitMetadataService.submitMetadata(metadataProps);
        result.put("path", "/content/forms/portal/render.dor.pdf/" + result.getString("submitID"));
        return result;
    }

    protected String getStatus() {
        return "submitted";
    }

    protected String getNodeType() {
        return "fp:submittedForm";
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }

    protected void bindFpPdfRenderService(FormsPortalPDFRenderService formsPortalPDFRenderService) {
        this.fpPdfRenderService = formsPortalPDFRenderService;
    }

    protected void unbindFpPdfRenderService(FormsPortalPDFRenderService formsPortalPDFRenderService) {
        if (this.fpPdfRenderService == formsPortalPDFRenderService) {
            this.fpPdfRenderService = null;
        }
    }

    protected void bindFpSubmittedAFUserDataService(SubmittedAFDataService submittedAFDataService) {
        this.fpSubmittedAFUserDataService = submittedAFDataService;
    }

    protected void unbindFpSubmittedAFUserDataService(SubmittedAFDataService submittedAFDataService) {
        if (this.fpSubmittedAFUserDataService == submittedAFDataService) {
            this.fpSubmittedAFUserDataService = null;
        }
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }
}

