/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.common;

import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.adobe.granite.security.user.UserManagementService;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={PortalUtilsComponent.class})
@Component
public class PortalUtilsComponent {
    private final Logger log = LoggerFactory.getLogger(PortalUtilsComponent.class);
    @Reference(referenceInterface=FormsPortalDraftsandSubmissionConfigService.class)
    private FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;
    @Reference
    private UserManagementService usermgmtService;
    @Reference
    ResourceResolverHelper resourceResolverHelper;
    @Reference
    private SlingRepository repository = null;
    @Reference
    private QueryBuilder queryBuilder;

    public String getDDSFilter() {
        String draftDataFilter = "(aem.formsportal.impl.prop=" + this.draftsandSubmissionConfiguration.getDraftDataService() + ")";
        return draftDataFilter;
    }

    public String getDMSFilter() {
        String draftMetadataFilter = "(aem.formsportal.impl.prop=" + this.draftsandSubmissionConfiguration.getDraftMetadataService() + ")";
        return draftMetadataFilter;
    }

    public String getSDSFilter() {
        String submitDataFilter = "(aem.formsportal.impl.prop=" + this.draftsandSubmissionConfiguration.getSubmitDataService() + ")";
        return submitDataFilter;
    }

    public String getSMSFilter() {
        String submitMetadataFilter = "(aem.formsportal.impl.prop=" + this.draftsandSubmissionConfiguration.getSubmitMetadataService() + ")";
        return submitMetadataFilter;
    }

    public String getPDSFilter() {
        String pendingSignDataFilter = "(aem.formsportal.impl.prop=" + this.draftsandSubmissionConfiguration.getPendingSignDataService() + ")";
        return pendingSignDataFilter;
    }

    public String getPMSFilter() {
        String pendingSignMetadataFilter = "(aem.formsportal.impl.prop=" + this.draftsandSubmissionConfiguration.getPendingSignMetadataService() + ")";
        return pendingSignMetadataFilter;
    }

    public boolean isLoginAnonymous() {
        String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
        String anonymousId = this.usermgmtService.getAnonymousId();
        return anonymousId != null && anonymousId.equals(userName);
    }

    public boolean isReviewer(Session currentSession, String formPath) throws Exception {
        try {
            if (currentSession != null && formPath != null && !formPath.trim().isEmpty()) {
                Node formNode = currentSession.getNode(formPath);
                RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                Node metadataNode = repUtils.getMetadataNode(formNode, false);
                if (metadataNode.hasProperty("form-submission-reviewer-group") && metadataNode.getProperty("form-submission-reviewer-group") != null) {
                    String allowedGroupId = metadataNode.getProperty("form-submission-reviewer-group").getString();
                    UserManager userManager = AccessControlUtil.getUserManager(currentSession);
                    Authorizable authorizable = userManager.getAuthorizable(currentSession.getUserID());
                    Iterator<Group> grpItr = authorizable.declaredMemberOf();
                    while (grpItr.hasNext()) {
                        Group group = grpItr.next();
                        if (!group.getID().equals(allowedGroupId)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error occured while verifying if user is authorized or not", e);
        }
        return false;
    }

    public boolean isOwner(Session currentSession, String submitID) throws FormsPortalException {
        if (currentSession != null && submitID != null) {
            return this.getMetadataNodeFromSubmitID(submitID, currentSession) != null;
        }
        return false;
    }

    public Node getMetadataNodeFromSubmitID(String submitID, Session session) throws FormsPortalException {
        try {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("path", "/content/forms/fp");
            queryMap.put("type", "nt:unstructured");
            queryMap.put("0_property", "submitID");
            queryMap.put("0_property.value", submitID);
            queryMap.put("1_property", "nodeType");
            queryMap.put("1_property.value", "fp:submittedForm");
            PredicateGroup predicates = PredicateGroup.create(queryMap);
            Query query = this.queryBuilder.createQuery(predicates, session);
            SearchResult result = query.getResult();
            Node submitMetadataNode = null;
            if (result.getTotalMatches() == 1L) {
                Iterator<Node> it = result.getNodes();
                it.hasNext();
                submitMetadataNode = it.next();
            } else {
                RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
                Node userNode = repUtils.getUserNode(userName, false, session);
                String submitNodeRelativePath = "submit/metadata/" + submitID;
                if (userNode != null && userNode.hasNode(submitNodeRelativePath)) {
                    submitMetadataNode = userNode.getNode(submitNodeRelativePath);
                }
            }
            return submitMetadataNode;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
    }

    public static <T> T[] removeFromArray(T[] objArray, T key) {
        ArrayList<Object> objList = new ArrayList<Object>(Arrays.asList(objArray));
        objList.remove(key);
        Object[] resultArray = (Object[])Array.newInstance(key.getClass(), objList.size());
        objList.toArray(resultArray);
        return resultArray;
    }

    public boolean isLoginAnonymous(String userName) {
        String anonymousId = this.usermgmtService.getAnonymousId();
        return anonymousId != null && anonymousId.equals(userName);
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }

    protected void bindUsermgmtService(UserManagementService userManagementService) {
        this.usermgmtService = userManagementService;
    }

    protected void unbindUsermgmtService(UserManagementService userManagementService) {
        if (this.usermgmtService == userManagementService) {
            this.usermgmtService = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

