/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.external;

import com.adobe.aemds.guide.service.external.FormPortalSubmitPreprocessor;
import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.service.DraftAndSubmissionUtilService;
import com.adobe.fd.fp.service.FormsPortalProcessor;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={FormPortalSubmitPreprocessor.class})
public class FormPortalSubmitPreprocessorImpl
implements FormPortalSubmitPreprocessor {
    private final Logger log = LoggerFactory.getLogger(FormPortalSubmitPreprocessorImpl.class);
    @Reference(referenceInterface=DraftAndSubmissionUtilService.class)
    private DraftAndSubmissionUtilService dsUtil;
    @Reference(target="(processorType=SUBMIT)")
    private FormsPortalProcessor submitProcessor;
    @Reference(target="(processorType=SIGN)", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private volatile FormsPortalProcessor signProcessor;

    @Override
    public PortalRecordInfo doPreProcess(Map<String, Object> options) {
        PortalRecordInfo preProcessorResult = null;
        try {
            String draftID = (String)options.get("draftID");
            try {
                if (!StringUtils.isEmpty(draftID)) {
                    this.dsUtil.deleteDraft(draftID);
                }
            }
            catch (Exception e) {
                this.log.error("Draft is either deleted already or an error occured while deleting it", e);
            }
            if (options.containsKey("signAgreementInfo")) {
                if (this.signProcessor == null) {
                    throw new FormsPortalException("ALC-FMP-001-053");
                }
                preProcessorResult = this.signProcessor.doPreProcess(options);
            } else if (options.containsKey("enablePortalSubmit") && ((Boolean)options.get("enablePortalSubmit")).booleanValue()) {
                preProcessorResult = this.submitProcessor.doPreProcess(options);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return preProcessorResult;
    }

    protected void bindDsUtil(DraftAndSubmissionUtilService draftAndSubmissionUtilService) {
        this.dsUtil = draftAndSubmissionUtilService;
    }

    protected void unbindDsUtil(DraftAndSubmissionUtilService draftAndSubmissionUtilService) {
        if (this.dsUtil == draftAndSubmissionUtilService) {
            this.dsUtil = null;
        }
    }

    protected void bindSubmitProcessor(FormsPortalProcessor formsPortalProcessor) {
        this.submitProcessor = formsPortalProcessor;
    }

    protected void unbindSubmitProcessor(FormsPortalProcessor formsPortalProcessor) {
        if (this.submitProcessor == formsPortalProcessor) {
            this.submitProcessor = null;
        }
    }

    protected void bindSignProcessor(FormsPortalProcessor formsPortalProcessor) {
        this.signProcessor = formsPortalProcessor;
    }

    protected void unbindSignProcessor(FormsPortalProcessor formsPortalProcessor) {
        if (this.signProcessor == formsPortalProcessor) {
            this.signProcessor = null;
        }
    }
}

