/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.external;

import com.adobe.aemds.guide.service.GuideDraftStateProvider;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.service.DraftAFDataService;
import com.adobe.fd.fp.service.DraftDataService;
import com.adobe.fd.fp.service.DraftMetadataService;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.forms.common.service.DataOptions;
import com.adobe.forms.common.service.DataProvider;
import com.adobe.forms.common.service.FormsException;
import com.adobe.forms.common.service.PrefillData;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;

@Component(metatype=false, immediate=true, label="FormsPortalDraftDataProviderImpl")
@Service(value={GuideDraftStateProvider.class, DataProvider.class})
public class FormsPortalDraftDataProviderImpl
implements GuideDraftStateProvider,
DataProvider {
    @Property(intValue={2100})
    static final String SERVICE_RANKING = "service.ranking";
    @Reference(referenceInterface=PortalUtilsComponent.class)
    private PortalUtilsComponent portalUtilsComponent;
    @Reference(referenceInterface=DraftAFDataService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private volatile DraftAFDataService fpAfDataService;
    @Reference(referenceInterface=ResourceResolverHelper.class)
    ResourceResolverHelper resourceResolverHelper;
    @Reference(referenceInterface=FormsPortalDraftsandSubmissionConfigService.class)
    private FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;

    @Override
    public String getGuideDraftState(String draftID) throws GuideException {
        return this.getData(draftID);
    }

    private String getData(String draftID) {
        String response;
        block5: {
            response = null;
            try {
                DraftMetadataService fpDraftMetadataService = (DraftMetadataService)PortalUtils.getService(DraftMetadataService.class, this.portalUtilsComponent.getDMSFilter());
                DraftDataService fpDraftDataService = (DraftDataService)PortalUtils.getService(DraftDataService.class, this.portalUtilsComponent.getDDSFilter());
                if (draftID.startsWith("/content/forms/fp")) {
                    draftID = draftID.substring(draftID.lastIndexOf("/") + 1);
                }
                String userdataID = null;
                if (StringUtils.isNotEmpty(draftID) && !draftID.contains("//")) {
                    userdataID = fpDraftMetadataService.getProperty(draftID, "userdataID")[0];
                }
                if (userdataID != null && !userdataID.trim().isEmpty()) {
                    response = this.fpAfDataService != null ? new String(this.fpAfDataService.getAFDraftUserData(userdataID), "UTF-8") : new String(fpDraftDataService.getData(userdataID), "UTF-8");
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                throw new GuideException(e.getMessage(), e);
            }
        }
        return response;
    }

    @Override
    public PrefillData getPrefillData(DataOptions options) throws FormsException {
        String data;
        String draftID = options.getDataRef();
        PrefillData prefillData = null;
        if (StringUtils.isNotEmpty(draftID) && StringUtils.isNotEmpty(data = this.getData(draftID))) {
            ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            prefillData = new PrefillData(is, options.getContentType());
        }
        return prefillData;
    }

    @Override
    public String getServiceDescription() {
        return null;
    }

    @Override
    public String getServiceName() {
        return null;
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }

    protected void bindFpAfDataService(DraftAFDataService draftAFDataService) {
        this.fpAfDataService = draftAFDataService;
    }

    protected void unbindFpAfDataService(DraftAFDataService draftAFDataService) {
        if (this.fpAfDataService == draftAFDataService) {
            this.fpAfDataService = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }
}

