/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.util;

import com.adobe.fd.fp.common.PortalUtilsComponent;
import com.adobe.fd.fp.config.FormsPortalDraftsandSubmissionConfigService;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.model.DraftMetadata;
import com.adobe.fd.fp.service.FPKeyGeneratorService;
import com.adobe.fd.fp.service.Statement;
import com.adobe.fd.fp.service.StatementGroup;
import com.adobe.fd.fp.util.FormsPortalConstants;
import com.adobe.fd.fp.util.PortalUtils;
import com.adobe.fd.fp.util.PropertyUtils;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.Replicator;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;

@Component
public abstract class MetadataBaseService {
    @Reference
    protected ResourceResolverHelper resourceResolverHelper;
    @Reference
    protected FormsPortalDraftsandSubmissionConfigService draftsandSubmissionConfiguration;
    @Reference
    protected PortalUtilsComponent portalUtilsComponent;
    @Reference
    protected SlingRepository slingRepository;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected FPKeyGeneratorService fpKeyGeneratorService;
    @Reference
    protected QueryBuilder queryBuilder;
    @Reference
    protected Replicator replicator;
    @Reference
    protected SlingSettingsService slingSettingService;
    protected String instanceType;
    protected String nodeType;
    protected String idProperty;
    private static final Map<Statement.Operator, String> jcrOperatorMap = new HashMap<Statement.Operator, String>();

    protected JSONObject saveMetadataInternal(Map<String, Object> metadataPropMap) throws FormsPortalException {
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        boolean isOwner = false;
        Session sysUserSession = null;
        JSONObject jsonObject = null;
        try {
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            String instanceID = (String)metadataPropMap.get(this.idProperty);
            Node currentInstanceMetadataNode = null;
            boolean isUserAllowed = false;
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            if (instanceID == null || instanceID.trim().isEmpty()) {
                instanceID = this.fpKeyGeneratorService.getUniqueId();
                currentInstanceMetadataNode = this.addMetadataNode(metadataPropMap, repUtils, sysUserSession, instanceID);
                isUserAllowed = true;
            } else {
                currentInstanceMetadataNode = this.getMetadataNodeFromInstanceID(instanceID, sysUserSession);
                if (currentInstanceMetadataNode == null && (currentInstanceMetadataNode = this.getInstanceNodeForProperty(instanceID, sysUserSession)) == null) {
                    currentInstanceMetadataNode = this.addMetadataNode(metadataPropMap, repUtils, sysUserSession, instanceID);
                }
                String formPath = currentInstanceMetadataNode.hasProperty("formPath") ? currentInstanceMetadataNode.getProperty("formPath").getString() : null;
                isUserAllowed = this.portalUtilsComponent.isReviewer(currentSession, formPath);
                isOwner = this.isOwner(currentSession, instanceID);
                if (isOwner && !isUserAllowed) {
                    HashSet<String> allowedKeys = new HashSet<String>(Arrays.asList(FormsPortalConstants.STR_UPDATION_ALLOWED_PROPERTIES));
                    metadataPropMap.keySet().retainAll(allowedKeys);
                }
            }
            if (isUserAllowed || isOwner) {
                PortalUtils.updatePropertiesOnNode(metadataPropMap, currentInstanceMetadataNode);
                currentInstanceMetadataNode.setProperty(this.instanceType + "ID", instanceID);
                this.updateLastModified(currentInstanceMetadataNode);
                sysUserSession.save();
                if (this.slingSettingService.getRunModes().contains("publish")) {
                    PortalUtils.reverseReplicate(sysUserSession, currentInstanceMetadataNode.getPath().toString(), ReplicationActionType.ACTIVATE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
                }
                jsonObject = this.postProcessMetadataNode(currentInstanceMetadataNode);
            }
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
        return jsonObject;
    }

    protected Node addMetadataNode(Map<String, Object> metadataPropMap, RepositoryUtils repUtils, Session sysUserSession, String instanceID) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, UnsupportedEncodingException, FormsPortalException {
        Node userNode = repUtils.getUserNode(this.getUserName(sysUserSession, (String)metadataPropMap.get("owner")), true, sysUserSession);
        Node rootNode = repUtils.getChildNode(userNode, this.instanceType, "sling:OrderedFolder", true);
        Node currentInstanceNode = repUtils.getChildNode(rootNode, "metadata", "sling:OrderedFolder", true);
        Node currentInstanceMetadataNode = repUtils.getChildNode(currentInstanceNode, instanceID, "{http://www.jcp.org/jcr/nt/1.0}unstructured", true);
        return currentInstanceMetadataNode;
    }

    protected boolean deleteMetadataInternal(String id) throws FormsPortalException {
        boolean status;
        block14: {
            status = false;
            boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            Session sysUserSession = null;
            if (id == null || id.trim().isEmpty()) {
                throw new FormsPortalException("ALC-FMP-001-016");
            }
            try {
                sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
                RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
                String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
                if (isAnonymous) {
                    currentSession = sysUserSession;
                }
                Node userNode = repUtils.getUserNode(userName, false, currentSession);
                Node instanceMetadataNode = this.getMetadataNodeFromInstanceID(id, currentSession);
                if ((userName.equals(sysUserSession.getUserID()) || userNode != null) && instanceMetadataNode != null) {
                    if (instanceMetadataNode.hasProperty(this.idProperty)) {
                        if (currentSession != null) {
                            if (this.slingSettingService.getRunModes().contains("publish")) {
                                PortalUtils.reverseReplicate(sysUserSession, instanceMetadataNode.getPath(), ReplicationActionType.DELETE, this.replicator, this.draftsandSubmissionConfiguration.getFormsPortalOutboxes());
                            } else {
                                PortalUtils.replicate(sysUserSession, instanceMetadataNode.getPath(), ReplicationActionType.DELETE, this.replicator);
                            }
                            currentSession.getNode(instanceMetadataNode.getPath()).remove();
                            currentSession.save();
                            status = true;
                            break block14;
                        }
                        throw new FormsPortalException("ALC-FMP-001-017");
                    }
                    throw new FormsPortalException("ALC-FMP-001-051", new Object[]{this.instanceType, id});
                }
                throw new FormsPortalException("ALC-FMP-001-020");
            }
            catch (FormsPortalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FormsPortalException(e);
            }
            finally {
                if (sysUserSession != null) {
                    sysUserSession.logout();
                }
            }
        }
        return status;
    }

    protected JSONArray getInstances(String cutPoints) throws FormsPortalException {
        ArrayList<DraftMetadata> instancesList = new ArrayList<DraftMetadata>();
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
        Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
        JSONArray instancesArray = new JSONArray();
        try {
            Node instanceRootnode;
            Node userNode = repUtils.getUserNode(userName, false, currentSession);
            if (userNode != null && !this.portalUtilsComponent.isLoginAnonymous() && (instanceRootnode = repUtils.getChildNode(userNode, this.instanceType, "sling:OrderedFolder", false)) != null && instanceRootnode.hasNode("metadata")) {
                Node metaDataRootNode = repUtils.getChildNode(instanceRootnode, "metadata", "sling:OrderedFolder", false);
                instancesList.addAll(this.readInstances(metaDataRootNode, cutPoints));
                Collections.sort(instancesList);
                JSONObject formJson = null;
                for (DraftMetadata instanceMetadata : instancesList) {
                    formJson = instanceMetadata.getJSONObject();
                    instancesArray.put(formJson);
                }
            }
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (ItemExistsException e) {
            throw new FormsPortalException(e);
        }
        catch (PathNotFoundException e) {
            throw new FormsPortalException(e);
        }
        catch (NoSuchNodeTypeException e) {
            throw new FormsPortalException(e);
        }
        catch (LockException e) {
            throw new FormsPortalException(e);
        }
        catch (VersionException e) {
            throw new FormsPortalException(e);
        }
        catch (ConstraintViolationException e) {
            throw new FormsPortalException(e);
        }
        catch (RepositoryException e) {
            throw new FormsPortalException(e);
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        return instancesArray;
    }

    protected boolean deletePropertyInternal(String instanceID, String propertyName) throws FormsPortalException {
        boolean isAnonymous = this.portalUtilsComponent.isLoginAnonymous();
        Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
        Session sysUserSession = null;
        try {
            RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
            if (isAnonymous) {
                currentSession = sysUserSession;
            }
            Node instanceMetadataNode = this.getMetadataNodeFromInstanceID(instanceID, currentSession);
            Node userNode = repUtils.getUserNode(userName, false, currentSession);
            if ((userName.equals(sysUserSession.getUserID()) || userNode != null) && instanceMetadataNode != null && instanceMetadataNode != null && instanceMetadataNode.hasProperty(propertyName)) {
                Property prop = instanceMetadataNode.getProperty(propertyName);
                prop.setValue((String[])null);
                currentSession.save();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsPortalException("ALC-FMP-001-052", e, new Object[]{propertyName, this.instanceType, instanceID});
        }
        finally {
            if (isAnonymous) {
                currentSession.logout();
            }
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
    }

    public String[] getProperty(String instanceID, String propertyName) throws FormsPortalException {
        String[] result = new String[]{""};
        Session sysUserSession = null;
        try {
            Property prop;
            sysUserSession = PortalUtils.getFnDServiceUserSession(this.slingRepository);
            Session currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            String userName = currentSession.getUserID();
            Node instanceMetadataNode = this.getMetadataNodeFromInstanceID(instanceID, currentSession);
            if (instanceMetadataNode == null) {
                if (this.portalUtilsComponent.isLoginAnonymous()) {
                    String metadatNodePathForAnon = this.draftsandSubmissionConfiguration.getFormsPortalRoot() + "/" + userName + "/" + this.instanceType + "/" + "metadata" + "/" + instanceID;
                    if (sysUserSession.nodeExists(metadatNodePathForAnon)) {
                        instanceMetadataNode = sysUserSession.getNode(metadatNodePathForAnon);
                    }
                } else {
                    instanceMetadataNode = this.getInstanceNodeForProperty(instanceID, sysUserSession);
                }
            }
            if (instanceMetadataNode != null && instanceMetadataNode.hasProperty(propertyName) && (prop = instanceMetadataNode.getProperty(propertyName)) != null) {
                if (!prop.isMultiple()) {
                    String propValue = instanceMetadataNode.getProperty(propertyName).getString();
                    result = new String[]{propValue};
                } else {
                    Value[] propValueList = instanceMetadataNode.getProperty(propertyName).getValues();
                    ArrayList<String> attachmentStringList = new ArrayList<String>();
                    for (Value propVals : propValueList) {
                        String propValStr = propVals.getString();
                        attachmentStringList.add(propValStr);
                    }
                    result = attachmentStringList.toArray(new String[0]);
                }
            }
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsPortalException("ALC-FMP-001-052", e, new Object[]{propertyName, this.instanceType, instanceID});
        }
        finally {
            if (sysUserSession != null) {
                sysUserSession.logout();
            }
        }
        return result;
    }

    protected Node getInstanceNodeForProperty(String instanceID, Session sysUserSession) throws Exception {
        return null;
    }

    private List<DraftMetadata> readInstances(Node instanceRootNode, String cutPoints) throws ValueFormatException, PathNotFoundException, RepositoryException, Exception {
        ArrayList<DraftMetadata> instancesList = new ArrayList<DraftMetadata>();
        NodeIterator itr = instanceRootNode.getNodes();
        while (itr.hasNext()) {
            instancesList.add(this.readInstance(itr.nextNode(), cutPoints));
        }
        return instancesList;
    }

    protected abstract JSONObject postProcessMetadataNode(Node var1) throws FormsPortalException;

    protected abstract DraftMetadata readInstance(Node var1, String var2) throws FormsPortalException;

    protected JSONObject readInstance(String instanceID, String cutPoints) throws FormsPortalException {
        if (StringUtils.isEmpty(instanceID)) {
            throw new FormsPortalException("ALC-FMP-001-016");
        }
        Session currentSession = null;
        try {
            currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class);
            Node currentInstanceUserdataNode = this.getMetadataNodeFromInstanceID(instanceID, currentSession);
            return this.readInstance(currentInstanceUserdataNode, cutPoints).getJSONObject();
        }
        catch (FormsPortalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
    }

    protected void readCommonProperties(Node instanceMetadataNode, DraftMetadata metadata, String cutPoints) throws PathNotFoundException, RepositoryException, Exception {
        if (instanceMetadataNode.hasProperty("formName")) {
            metadata.setName((String)PropertyUtils.getPropertyValue(instanceMetadataNode.getProperty("formName")));
        } else if (instanceMetadataNode.hasProperty("guideName")) {
            metadata.setName((String)PropertyUtils.getPropertyValue(instanceMetadataNode.getProperty("guideName")));
        }
        if (instanceMetadataNode.hasProperty("owner")) {
            metadata.setOwner((String)PropertyUtils.getPropertyValue(instanceMetadataNode.getProperty("owner")));
        }
        Object lastModifiedObj = PropertyUtils.getPropertyValue(instanceMetadataNode.getProperty("jcr:lastModified"));
        Date lastModifiedDate = null;
        if (lastModifiedObj instanceof Date) {
            lastModifiedDate = (Date)lastModifiedObj;
        } else if (lastModifiedObj instanceof String) {
            lastModifiedDate = new Date(Long.valueOf((String)lastModifiedObj));
        } else if (lastModifiedObj instanceof Long) {
            lastModifiedDate = new Date((Long)lastModifiedObj);
        }
        metadata.setLastModified(lastModifiedDate);
        if (instanceMetadataNode.hasProperty("description")) {
            metadata.setDescription((String)PropertyUtils.getPropertyValue(instanceMetadataNode.getProperty("description")));
        }
        List<String> cutPointsList = Arrays.asList(cutPoints.split(","));
        for (String cutPoint : cutPointsList) {
            String rt;
            if (instanceMetadataNode.hasProperty(cutPoint)) {
                metadata.setCustomProperty(cutPoint, String.valueOf(PropertyUtils.getPropertyValue(instanceMetadataNode.getProperty(cutPoint))));
            } else if (cutPoint.equals("name")) {
                metadata.setCustomProperty("name", metadata.getName());
            } else {
                metadata.setCustomProperty(cutPoint, "");
            }
            if (!cutPoint.equalsIgnoreCase("showDorClass") || (rt = instanceMetadataNode.getProperty("sling:resourceType").getString()).equalsIgnoreCase("fd/fp/components/opensubmittedguide/xfaaf")) continue;
            metadata.setCustomProperty(cutPoint, "__FP_display_none");
        }
        String instanceNodePath = instanceMetadataNode.getPath();
        Object[] instanceNodeSplit = instanceNodePath.split("/");
        if (instanceNodeSplit != null) {
            instanceNodeSplit[4] = URLEncoder.encode((String)instanceNodeSplit[4], "UTF-8");
        }
        instanceNodePath = StringUtils.join(instanceNodeSplit, "/");
        metadata.setPath(instanceNodePath);
    }

    protected Node getMetadataNodeFromInstanceID(String instanceID, Session session) throws FormsPortalException {
        Node instanceMetadataNode = null;
        try {
            RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
            String userName = this.resourceResolverHelper.getResourceResolver().getUserID();
            Node userNode = repUtils.getUserNode(userName, false, session);
            String instanceNodeRelativePath = this.instanceType + "/" + "metadata" + "/" + instanceID;
            if (userNode != null && userNode.hasNode(instanceNodeRelativePath)) {
                instanceMetadataNode = userNode.getNode(instanceNodeRelativePath);
            }
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        return instanceMetadataNode;
    }

    protected Node searchInstanceMetadataNode(String instanceID, Session session) throws Exception {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("path", "/content/forms/fp");
        queryMap.put("type", "nt:unstructured");
        queryMap.put("0_property", this.idProperty);
        queryMap.put("0_property.value", instanceID);
        queryMap.put("1_property", "nodeType");
        queryMap.put("1_property.value", this.nodeType);
        PredicateGroup predicates = PredicateGroup.create(queryMap);
        Query query = this.queryBuilder.createQuery(predicates, session);
        SearchResult result = query.getResult();
        Node instanceMetadataNode = null;
        if (result.getTotalMatches() == 1L) {
            Iterator<Node> it = result.getNodes();
            it.hasNext();
            instanceMetadataNode = it.next();
        }
        return instanceMetadataNode;
    }

    protected void updateLastModified(Node node) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Calendar lastModified = Calendar.getInstance();
        node.setProperty("jcr:lastModified", lastModified);
    }

    private String getUserName(Session sysUserSession, String userName) throws FormsPortalException {
        String currentUserName = this.resourceResolverHelper.getResourceResolver().getUserID();
        if (currentUserName.equals(sysUserSession.getUserID())) {
            currentUserName = userName;
        }
        return currentUserName;
    }

    public boolean isOwner(Session currentSession, String submitID) throws FormsPortalException {
        if (currentSession != null && submitID != null) {
            return this.getMetadataNodeFromInstanceID(submitID, currentSession) != null;
        }
        return false;
    }

    protected JSONArray searchInstances(com.adobe.fd.fp.service.Query query, Session session) throws FormsPortalException {
        JSONArray jsonArray = new JSONArray();
        if (query != null && query.getStatementGroup() != null) {
            PredicateGroup predicates = this.transformStatementGroup(query.getStatementGroup());
            Query cqQuery = this.queryBuilder.createQuery(predicates, session);
            cqQuery.setStart(query.getOffset());
            cqQuery.setHitsPerPage(query.getLimit());
            SearchResult result = cqQuery.getResult();
            Iterator<Node> itr = result.getNodes();
            while (itr.hasNext()) {
                Node node = itr.next();
                try {
                    jsonArray.put(this.readInstance(node, query.getCutPoints()).getJSONObject());
                }
                catch (JSONException e) {
                    throw new FormsPortalException(e);
                }
            }
        }
        return jsonArray;
    }

    private Predicate transformStatement(Statement statement) {
        Predicate predicate = null;
        if (!StringUtils.isEmpty(statement.getAttributeName()) && !StringUtils.isEmpty(statement.getAttributeValue())) {
            predicate = new Predicate("property");
            predicate.set("property", statement.getAttributeName());
            if (statement.getOperator() != Statement.Operator.EXISTS) {
                predicate.set("value", statement.getAttributeValue());
            }
            predicate.set("operation", jcrOperatorMap.get((Object)statement.getOperator()));
        }
        return predicate;
    }

    private PredicateGroup transformStatementGroup(StatementGroup statementGroup) {
        PredicateGroup predicates = null;
        if (statementGroup.getStatements() != null) {
            predicates = new PredicateGroup();
            for (Statement statement : statementGroup.getStatements()) {
                Predicate predicate = this.transformStatement(statement);
                if (predicate == null) continue;
                predicates.add(predicate);
            }
            if (statementGroup.getJoinOperator() == StatementGroup.JoinOperator.OR) {
                predicates.setAllRequired(false);
            }
        }
        this.addDefaultPredicates(predicates);
        return predicates;
    }

    private void addDefaultPredicates(PredicateGroup predicates) {
        Predicate pathPedicate = new Predicate("path");
        pathPedicate.set("path", "/content/forms/fp");
        predicates.add(pathPedicate);
        Predicate typePredicate = new Predicate("type");
        typePredicate.set("type", "nt:unstructured");
        predicates.add(typePredicate);
    }

    static {
        jcrOperatorMap.put(Statement.Operator.EQUALS, "equals");
        jcrOperatorMap.put(Statement.Operator.NOT_EQUALS, "equals");
        jcrOperatorMap.put(Statement.Operator.EXISTS, "exists");
        jcrOperatorMap.put(Statement.Operator.NOT, "not");
        jcrOperatorMap.put(Statement.Operator.LIKE, "like");
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        this.draftsandSubmissionConfiguration = formsPortalDraftsandSubmissionConfigService;
    }

    protected void unbindDraftsandSubmissionConfiguration(FormsPortalDraftsandSubmissionConfigService formsPortalDraftsandSubmissionConfigService) {
        if (this.draftsandSubmissionConfiguration == formsPortalDraftsandSubmissionConfigService) {
            this.draftsandSubmissionConfiguration = null;
        }
    }

    protected void bindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        this.portalUtilsComponent = portalUtilsComponent;
    }

    protected void unbindPortalUtilsComponent(PortalUtilsComponent portalUtilsComponent) {
        if (this.portalUtilsComponent == portalUtilsComponent) {
            this.portalUtilsComponent = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindFpKeyGeneratorService(FPKeyGeneratorService fPKeyGeneratorService) {
        this.fpKeyGeneratorService = fPKeyGeneratorService;
    }

    protected void unbindFpKeyGeneratorService(FPKeyGeneratorService fPKeyGeneratorService) {
        if (this.fpKeyGeneratorService == fPKeyGeneratorService) {
            this.fpKeyGeneratorService = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindSlingSettingService(SlingSettingsService slingSettingsService) {
        this.slingSettingService = slingSettingsService;
    }

    protected void unbindSlingSettingService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingService == slingSettingsService) {
            this.slingSettingService = null;
        }
    }
}

