/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFEncodingBuilder;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class PDFEncodingBuilderImpl
extends PDFEncodingBuilder
implements Cmap.CmapSelector {
    private final List revMapList;
    private Subset s;
    private OpenTypeFont f;

    public PDFEncodingBuilderImpl(OpenTypeFont font, Subset s) throws UnsupportedFontException, InvalidFontException {
        this.s = s;
        this.f = font;
        this.revMapList = new ArrayList(5);
        font.cmap.enumerateCmaps(this);
        this.f = null;
    }

    public int getCodePoint(int subsetGlyphID, PDFEncodingBuilder.Encoding e) {
        Iterator iter = this.revMapList.iterator();
        int fullGid = this.s.getFullGid(subsetGlyphID);
        while (iter.hasNext()) {
            RevMap map = (RevMap)iter.next();
            if (map.encoding != e || map.revMap[fullGid] == -1) continue;
            return map.revMap[fullGid];
        }
        return Integer.MAX_VALUE;
    }

    public PDFEncodingBuilder.Encoding getEncoding(int subsetGlyphID) {
        Iterator iter = this.revMapList.iterator();
        int fullGid = this.s.getFullGid(subsetGlyphID);
        while (iter.hasNext()) {
            RevMap map = (RevMap)iter.next();
            if (map.revMap[fullGid] == -1) continue;
            return map.encoding;
        }
        return null;
    }

    public void cmapFound(int pid, int eid, int index) throws UnsupportedFontException, InvalidFontException {
        int[] invertedCmap = null;
        PDFEncodingBuilder.Encoding e = null;
        switch (pid) {
            case 3: {
                switch (eid) {
                    case 1: 
                    case 10: {
                        e = PDFEncodingBuilder.Encoding.UNICODE;
                        break;
                    }
                    case 4: {
                        e = PDFEncodingBuilder.Encoding.MS_BIG5;
                        break;
                    }
                    case 6: {
                        e = PDFEncodingBuilder.Encoding.MS_JOHAB;
                        break;
                    }
                    case 3: {
                        e = PDFEncodingBuilder.Encoding.MS_PRC;
                        break;
                    }
                    case 2: {
                        e = PDFEncodingBuilder.Encoding.MS_SHIFT_JIS;
                        break;
                    }
                    case 5: {
                        e = PDFEncodingBuilder.Encoding.MS_WANSUNG;
                    }
                }
                if (e == null) break;
                invertedCmap = this.f.cmap.glyph2char(this.f.getNumGlyphs(), index);
                break;
            }
            case 0: {
                e = PDFEncodingBuilder.Encoding.UNICODE;
                invertedCmap = this.f.cmap.glyph2char(this.f.getNumGlyphs(), index);
            }
        }
        if (e != null) {
            int numGlyphsCovered = 0;
            for (int i = 0; i < this.s.getNumGlyphs(); ++i) {
                if (invertedCmap[this.s.getFullGid(i)] == -1) continue;
                ++numGlyphsCovered;
            }
            ListIterator<RevMap> iter = this.revMapList.listIterator();
            while (iter.hasNext()) {
                RevMap map = (RevMap)iter.next();
                if (map.numGlyphsCovered > numGlyphsCovered) continue;
                break;
            }
            RevMap newMap = new RevMap(e, invertedCmap, numGlyphsCovered);
            if (iter.hasPrevious()) {
                iter.previous();
            } else {
                iter = this.revMapList.listIterator();
            }
            iter.add(newMap);
        }
    }

    private static class RevMap {
        final PDFEncodingBuilder.Encoding encoding;
        final int[] revMap;
        final int numGlyphsCovered;

        RevMap(PDFEncodingBuilder.Encoding e, int[] revMap, int numGlyphsCovered) {
            this.revMap = revMap;
            this.numGlyphsCovered = numGlyphsCovered;
            this.encoding = e;
        }
    }
}

