/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public final class FallbackFontSet
implements Serializable {
    static final long serialVersionUID = 1L;
    private final HashMap fonts = new HashMap();
    private static final ULocale REAL_ROOT = new ULocale("");

    public FallbackFontSet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FallbackFontSet(FallbackFontSet ffs) {
        FallbackFontSet fallbackFontSet = ffs;
        synchronized (fallbackFontSet) {
            for (Object locale : ffs.fonts.keySet()) {
                ArrayList l = new ArrayList();
                this.fonts.put(locale, l);
                Iterator it2 = ((List)ffs.fonts.get(locale)).iterator();
                while (it2.hasNext()) {
                    l.add(it2.next());
                }
            }
        }
    }

    public void addFallbackFonts(ULocale locale, Font[] fontsToAdd) {
        for (Font font : fontsToAdd) {
            this.addFallbackFont(locale, font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFallbackFont(ULocale locale, Font font) {
        FallbackFontSet fallbackFontSet = this;
        synchronized (fallbackFontSet) {
            ArrayList<Font> l;
            if (locale.equals(ULocale.ROOT)) {
                locale = REAL_ROOT;
            }
            if ((l = (ArrayList<Font>)this.fonts.get(locale)) == null) {
                l = new ArrayList<Font>();
                this.fonts.put(locale, l);
            }
            l.add(font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFallbackFonts(ULocale locale) {
        FallbackFontSet fallbackFontSet = this;
        synchronized (fallbackFontSet) {
            return new FallbackFontIterator(locale);
        }
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject == null || !(otherObject instanceof FallbackFontSet)) {
            return false;
        }
        return this.fonts.equals(((FallbackFontSet)otherObject).fonts);
    }

    public int hashCode() {
        return this.fonts.hashCode();
    }

    public boolean isEmpty() {
        return this.fonts.isEmpty();
    }

    public boolean isEmpty(ULocale locale) {
        return this.fonts.containsKey(locale);
    }

    public String toString() {
        TreeMap tempMap3;
        TreeMap<String, ULocale> tempMap = new TreeMap<String, ULocale>();
        for (ULocale locale : this.fonts.keySet()) {
            tempMap.put(locale.getDisplayName(), locale);
        }
        HashMap tempMap1 = new HashMap();
        for (String displayName : tempMap.keySet()) {
            ULocale locale = (ULocale)tempMap.get(displayName);
            TreeMap<String, TreeMap> tempMap2 = new TreeMap<String, TreeMap>();
            for (Font f : (List)this.fonts.get(locale)) {
                String tempKey;
                tempMap3 = new TreeMap();
                try {
                    PostscriptFontDescription[] descs = f.getPostscriptFontDescription();
                    for (int i = 0; i < descs.length; ++i) {
                        String name = descs[i].toString();
                        int count = 0;
                        if (tempMap3.containsKey(name)) {
                            count = (Integer)tempMap3.get(name);
                        }
                        tempMap3.put(name, new Integer(++count));
                    }
                }
                catch (FontException e) {
                    // empty catch block
                }
                char suffix = '0';
                String string = tempKey = tempMap3.isEmpty() ? "" : (String)tempMap3.firstKey();
                while (tempMap2.containsKey(tempKey + suffix)) {
                    suffix = (char)(suffix + '\u0001');
                }
                tempMap2.put(tempKey + suffix, tempMap3);
            }
            tempMap1.put(locale, tempMap2);
        }
        StringBuffer sb = new StringBuffer();
        for (String displayName : tempMap.keySet()) {
            ULocale locale = (ULocale)tempMap.get(displayName);
            sb.append(displayName);
            sb.append(": ");
            String prefix2 = "";
            TreeMap tempMap2 = (TreeMap)tempMap1.get(locale);
            Iterator it1 = tempMap2.keySet().iterator();
            while (it1.hasNext()) {
                tempMap3 = (TreeMap)tempMap2.get(it1.next());
                sb.append(prefix2);
                sb.append("{");
                String prefix = "";
                for (String name : tempMap3.keySet()) {
                    int count = (Integer)tempMap3.get(name);
                    while (count-- > 0) {
                        sb.append(prefix);
                        sb.append(name);
                        prefix = ", ";
                    }
                }
                sb.append("}");
                sb.append(prefix2);
                prefix2 = ", ";
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private final class FallbackFontIterator
    implements Iterator {
        private ULocale locale;
        private Iterator localeIt;

        public FallbackFontIterator(ULocale locale) {
            this.locale = locale;
            this.localeIt = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            FallbackFontIterator fallbackFontIterator = this;
            synchronized (fallbackFontIterator) {
                while (this.localeIt != null || this.locale != null) {
                    if (this.localeIt == null) {
                        List l = (List)FallbackFontSet.this.fonts.get(this.locale);
                        if (l != null) {
                            this.localeIt = l.iterator();
                        }
                        this.locale = this.locale.getFallback();
                        continue;
                    }
                    if (this.localeIt.hasNext()) {
                        return true;
                    }
                    this.localeIt = null;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() throws NoSuchElementException {
            FallbackFontIterator fallbackFontIterator = this;
            synchronized (fallbackFontIterator) {
                if (this.hasNext()) {
                    return this.localeIt.next();
                }
            }
            throw new NoSuchElementException();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("cannot remove elements from a FallbackFontIterator");
        }
    }
}

