/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.common.servlet;

import com.adobe.forms.common.utils.FormsConstants;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="AEM Forms Temporary Storage Cleaning Task", description="Cleans the temporary storage used by AEM Forms")
@Service(value={Runnable.class})
@Properties(value={@Property(name="scheduler.expression", value={"0 0 12 * * ?"}, label="Cron expression scheduling this job", description="Cron expression scheduling this job. Default is every hour. See http://www.docjar.com/docs/api/org/quartz/CronTrigger.html for a description of the format for this value"), @Property(name="scheduler.concurrent", boolValue={false}, propertyPrivate=true)})
public class TempCleanUpTask
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(TempCleanUpTask.class);
    private Calendar todaysDate = Calendar.getInstance();
    private final String[] queryPaths = FormsConstants.FD_TEMP_PATHS;
    @Reference
    private SlingRepository slingRepository;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Property(name="Duration for Temporary Storage", value={"24"}, label="Cleans the temporary folder older than(In Hours)", description="Service will delete temporary nodes that were created before the (duration_temp_storage) from the current time")
    private static final Integer DURATION_TEMP_STORAGE = 24;
    private int duration_temp_storage;
    @Property(name="Duration for Anonymous Storage", value={"1"}, label="Cleans the anonymous temporary folder older than(In Hours)", description="Service will delete anonymous temporary nodes that were created before the (duration_temp_storage) from the current time")
    private static final Integer DURATION_ANONYMOUS_STORAGE = 1;
    private int duration_anonymous_storage;

    protected void activate(ComponentContext context) {
        Dictionary<String, Object> props = context.getProperties();
        this.duration_temp_storage = OsgiUtil.toInteger(props.get("Duration for Temporary Storage"), DURATION_TEMP_STORAGE);
        this.duration_anonymous_storage = OsgiUtil.toInteger(props.get("Duration for Anonymous Storage"), DURATION_ANONYMOUS_STORAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Session session = null;
        try {
            session = this.slingRepository.loginService(null, null);
            ArrayList<Node> staleNodesList = new ArrayList<Node>();
            this.getTempNodes(session, staleNodesList);
            for (Node staleNode : staleNodesList) {
                try {
                    staleNode.remove();
                }
                catch (Exception e) {
                    this.log.error("Error while removing the node [ " + staleNode.getPath() + "]", e);
                }
            }
            session.save();
        }
        catch (RepositoryException e) {
            this.log.error("Error while processing the uuid nodes list.", e);
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    private void getTempNodes(Session session, List<Node> staleNodesList) {
        try {
            for (int i = 0; i < this.queryPaths.length; ++i) {
                Node res = session.getNode(this.queryPaths[i]);
                NodeIterator nit = res.getNodes();
                while (nit.hasNext()) {
                    Node tmpNode = nit.nextNode();
                    if (!tmpNode.hasProperty("tmpNode")) continue;
                    this.isNodeStale(tmpNode, this.duration_temp_storage, staleNodesList);
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error("Error while querying for temp storages", e);
        }
    }

    private void getAnonymousTempNodes(Session session, List<Node> staleNodesList) {
        try {
            for (int i = 0; i < this.queryPaths.length; ++i) {
                ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(null);
                String query = "SELECT * FROM nt:base WHERE guideComponentType='anonymousTempStorage' AND jcr:path LIKE '" + this.queryPaths[i] + "%'";
                Iterator<Resource> anonymousResources = resolver.findResources(query, "sql");
                while (anonymousResources.hasNext()) {
                    Node tmpNode = anonymousResources.next().adaptTo(Node.class);
                    if (!tmpNode.hasProperty("guideComponentType") || !"anonymousTempStorage".equals(tmpNode.getProperty("guideComponentType").getString())) continue;
                    this.isNodeStale(tmpNode, this.duration_anonymous_storage, staleNodesList);
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error("Error while querying for temp storages", e);
        }
        catch (LoginException e) {
            this.log.error("Cannot provide  serviceResourceResolver", e);
        }
    }

    private void isNodeStale(Node tmpNode, int duration, List<Node> staleNodesList) {
        try {
            Calendar date = null;
            date = tmpNode.hasProperty("jcr:lastModified") ? tmpNode.getProperty("jcr:lastModified").getDate() : tmpNode.getProperty("jcr:created").getDate();
            date.add(11, duration);
            if (date.compareTo(this.todaysDate) <= 0) {
                staleNodesList.add(tmpNode);
            }
        }
        catch (RepositoryException e) {
            this.log.error("Error while comparing dates for temp storages", e);
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

