/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.service;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class FormsFoundationException
extends Exception {
    private static final long serialVersionUID = 1500623108187528483L;
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("formsFoundationErrorMessages");
    public static final String UNEXPECTED_ERROR = "AEM-FF-001";
    public static final String INVALID_INPUT_PARAMETERS = "AEM-FF-002";
    public static final String UNABLE_TO_CURRENT_USER_SESSION = "AEM-FF-003";
    public static final String NODE_DOES_NOT_EXISTS = "AEM-FF-004";
    public static final String UNABLE_TO_DETERMINE_ASSET_TYPE = "AEM-FF-005";
    public static final String ASSET_ALREADY_EXIST = "AEM-FF-006";
    public static final String MOVE_ASSET_FAILED = "AEM-FF-007";
    public static final String MOVE_UNAUTHORIZED_ACCESS = "AEM-FF-008";
    private String errorCode;
    private String unresolvedMessage;
    private Object[] arguments;
    private String message;

    public FormsFoundationException(String errorCode, Object[] args) {
        this.errorCode = errorCode;
        this.arguments = args;
        this.unresolvedMessage = resourceBundle.getString(errorCode);
        if (this.arguments == null) {
            this.message = this.unresolvedMessage;
        } else {
            MessageFormat messageFormat = new MessageFormat(this.unresolvedMessage);
            this.message = messageFormat.format(this.arguments);
        }
    }

    public FormsFoundationException() {
    }

    public FormsFoundationException(String message, Throwable cause) {
        super(message, cause);
    }

    public FormsFoundationException(Throwable cause) {
        super(cause);
    }

    public FormsFoundationException(String message) {
        super(message);
    }

    @Override
    public String getMessage() {
        if (this.errorCode != null) {
            return this.errorCode + ": " + this.message;
        }
        return super.getMessage();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getUnresolvedMessage() {
        return this.unresolvedMessage;
    }

    public Object[] getMessageArgs() {
        return this.arguments;
    }
}

