/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class LazyRandomAccessFileByteWriter
implements ByteWriter {
    private File file;
    private ByteWriter byteWriter;
    private boolean openFailed = false;

    public LazyRandomAccessFileByteWriter(File file) throws IOException {
        if (file == null) {
            throw new IOException("File is not valid.");
        }
        this.file = file;
    }

    @Override
    public int read(long position) throws IOException {
        return this.getByteWriter().read(position);
    }

    @Override
    public int read(long position, byte[] b, int offset, int length) throws IOException {
        return this.getByteWriter().read(position, b, offset, length);
    }

    @Override
    public long length() throws IOException {
        return this.getByteWriter().length();
    }

    @Override
    public void close() throws IOException {
        if (this.byteWriter != null) {
            this.byteWriter.close();
        }
        this.byteWriter = null;
        this.file = null;
    }

    private ByteWriter getByteWriter() throws IOException {
        if (this.byteWriter != null) {
            return this.byteWriter;
        }
        if (this.openFailed) {
            throw new IOException("Unable to open file.");
        }
        try {
            RandomAccessFile raf;
            try {
                raf = new RandomAccessFile(this.file, "r");
            }
            catch (Exception e) {
                IOException ioException = new IOException("Unable to open the RandomAccessFile for the File " + this.file);
                ioException.initCause(e);
                throw ioException;
            }
            this.byteWriter = new RandomAccessFileByteWriter(raf);
        }
        catch (IOException e) {
            this.openFailed = true;
        }
        return this.byteWriter;
    }

    @Override
    public void write(long position, int b) throws IOException {
        this.getByteWriter().write(position, b);
    }

    @Override
    public void write(long position, byte[] b, int offset, int length) throws IOException {
        this.getByteWriter().write(position, b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.getByteWriter().flush();
    }
}

