/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Dispatcher;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;

class ExecuteDispatcher
extends Dispatcher {
    private final Element mExecuteNode;
    private final boolean mbValidate;

    ExecuteDispatcher(Element scriptContextNode, String sEventContext, int nEventID, EventManager eventManager, Element executeNode, boolean bValidate) {
        super(scriptContextNode, sEventContext, nEventID, eventManager);
        this.mExecuteNode = executeNode;
        this.mbValidate = bValidate;
    }

    @Override
    public void dispatch() {
        Container container;
        int ePresence;
        TemplateModel templateModel;
        Element node = this.getActionContextNode();
        if (node == null) {
            return;
        }
        int eRunAt = this.getRunAt();
        String sConnection = this.getConnection();
        int eExecuteType = this.getExecuteType();
        assert (node instanceof FormField || node instanceof FormSubform || node instanceof FormExclGroup);
        FormModel formModel = (FormModel)node.getModel();
        int eModelRunAtSetting = formModel.getRunScripts();
        AppModel appModel = node.getAppModel();
        if (appModel != null && (templateModel = TemplateModel.getTemplateModel(appModel, false)) != null && templateModel.getOriginalXFAVersion() >= 30 && node instanceof Container && 1076494339 == (ePresence = (container = (Container)node).getRuntimePresence(0))) {
            return;
        }
        boolean bValid = true;
        if (this.mbValidate) {
            bValid = formModel.performPreEventValidations();
        }
        if (bValid) {
            FormModel.Execute execute;
            if (eRunAt != 1079836672 && eModelRunAtSetting == 1080754176) {
                formModel.serverExchange(node, "click");
            }
            if ((execute = formModel.getExecute()) == null) {
                return;
            }
            boolean bLegacyScripting = true;
            TemplateModel oTemplateModel = TemplateModel.getTemplateModel(appModel, true);
            if (null != oTemplateModel && !oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
                bLegacyScripting = false;
            }
            if (bLegacyScripting) {
                execute.execute(sConnection, eRunAt, eExecuteType);
            } else if (eRunAt != 1079836673) {
                execute.execute(sConnection, eRunAt, eExecuteType);
            }
        } else {
            ExFull exFull = new ExFull(ResId.FormExecuteCancelled);
            formModel.addErrorList(exFull, 3, this.getActionContextNode());
        }
    }

    int getRunAt() {
        if (this.mExecuteNode != null) {
            Attribute runAt = this.mExecuteNode.getAttribute(634);
            int eRunAt = ((EnumValue)runAt).getInt();
            return eRunAt;
        }
        return 1079836674;
    }

    String getConnection() {
        if (this.mExecuteNode != null) {
            Attribute connectionAttr = this.mExecuteNode.getAttribute(371);
            String sConnection = connectionAttr.toString();
            return sConnection;
        }
        return "";
    }

    int getExecuteType() {
        if (this.mExecuteNode != null) {
            Attribute executeType = this.mExecuteNode.getAttribute(498);
            int eExecuteType = ((EnumValue)executeType).getInt();
            return eExecuteType;
        }
        return 0x600000;
    }

    @Override
    public String getDispatcherType() {
        return "execute";
    }
}

